/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.core.swing;

import java.awt.Dimension;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import net.damaq.core.actions.SelectableCoreAction;
import net.damaq.core.swing.ToggleActionPropertyChangeListener;

public final class DamaqUI {
    private static final Dimension buttonDimension = new Dimension(24, 23);

    private DamaqUI() {
    }

    public static JToggleButton getToggleButton(SelectableCoreAction selectableCoreAction, Dimension dimension) {
        JToggleButton jToggleButton = new JToggleButton(selectableCoreAction);
        jToggleButton.setAction(selectableCoreAction);
        jToggleButton.setText(null);
        if (dimension != null) {
            jToggleButton.setMinimumSize(dimension);
            jToggleButton.setPreferredSize(dimension);
            jToggleButton.setMaximumSize(dimension);
        }
        jToggleButton.setMnemonic(0);
        jToggleButton.setFocusable(false);
        jToggleButton.setRolloverEnabled(false);
        DamaqUI.setSelectable(jToggleButton, selectableCoreAction);
        return jToggleButton;
    }

    public static JToggleButton getToggleButton(SelectableCoreAction selectableCoreAction) {
        return DamaqUI.getToggleButton(selectableCoreAction, null);
    }

    public static void setSelectable(AbstractButton abstractButton, SelectableCoreAction selectableCoreAction) {
        abstractButton.setAction(selectableCoreAction);
        selectableCoreAction.addPropertyChangeListener(new ToggleActionPropertyChangeListener(abstractButton));
        abstractButton.setSelected(selectableCoreAction.isSelected());
    }

    public static AbstractButton getButton(Action action, Dimension dimension) {
        JButton jButton = new JButton(action);
        jButton.setText("");
        jButton.setMnemonic(0);
        jButton.setMinimumSize(dimension);
        jButton.setPreferredSize(dimension);
        jButton.setMaximumSize(dimension);
        jButton.setFocusable(false);
        jButton.setRolloverEnabled(false);
        return jButton;
    }

    public static Dimension getButtonDimension() {
        return buttonDimension;
    }
}

