/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.core.swing;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import net.damaq.core.actions.CopyAction;
import net.damaq.core.actions.CutAction;
import net.damaq.core.actions.DeleteAction;
import net.damaq.core.actions.PasteAction;

public final class MouseEventQueue
extends EventQueue {
    protected final void dispatchEvent(AWTEvent aWTEvent) {
        super.dispatchEvent(aWTEvent);
        if (!(aWTEvent instanceof MouseEvent)) {
            return;
        }
        MouseEvent mouseEvent = (MouseEvent)aWTEvent;
        if (!mouseEvent.isPopupTrigger()) {
            return;
        }
        Component component = SwingUtilities.getDeepestComponentAt(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        if (!(component instanceof JTextComponent)) {
            // empty if block
        }
        if (MenuSelectionManager.defaultManager().getSelectedPath().length > 0) {
            return;
        }
        if (!(component instanceof JTextComponent)) {
            return;
        }
        JTextComponent jTextComponent = (JTextComponent)component;
        jTextComponent.grabFocus();
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(new CutAction());
        jPopupMenu.add(new CopyAction());
        jPopupMenu.add(new PasteAction());
        jPopupMenu.add(new DeleteAction(jTextComponent));
        jPopupMenu.addSeparator();
        Point point = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), jTextComponent);
        jPopupMenu.show(jTextComponent, point.x, point.y);
    }
}

