/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.core.swing;

import java.util.Collection;
import java.util.Iterator;
import java.util.Stack;
import javax.swing.DefaultComboBoxModel;
import net.damaq.core.AppPrefs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RecentsComboModel
extends DefaultComboBoxModel {
    private final Stack<String> stack;
    private String properties = null;
    private boolean autosave;

    public RecentsComboModel(String string, boolean bl) {
        this(new Stack<String>());
        String string2;
        this.properties = string;
        this.autosave = bl;
        int n = 0;
        while ((string2 = AppPrefs.getProperty(string + n, null)) != null) {
            if (string2.length() > 0) {
                this.stack.add(0, string2);
            }
            ++n;
        }
    }

    private RecentsComboModel(Stack<String> stack) {
        super(stack);
        this.stack = stack;
        this.autosave = false;
    }

    @Override
    public void setSelectedItem(Object object) {
        super.setSelectedItem(object);
        this.addElement(object);
    }

    @Override
    public final void addElement(Object object) {
        if (object == null) {
            return;
        }
        if (!object.equals("") && !object.equals("?") && this.getIndexOf(object) < 0) {
            super.insertElementAt(object, 0);
            if (this.stack.size() > 5) {
                this.remove(4);
            }
            if (this.autosave) {
                this.store();
            }
        }
    }

    private void remove(int n) {
        this.setSelectedItem(this.getElementAt(0));
        this.stack.removeElementAt(n);
        this.fireIntervalRemoved(this, n, n);
    }

    public final Collection<String> getList() {
        return this.stack;
    }

    public void removeAllProperties() {
        String string;
        int n = 0;
        while (AppPrefs.getProperty(string = this.properties + n, null) != null) {
            AppPrefs.removeProperty(string);
            ++n;
        }
    }

    public void store() {
        int n = this.stack.size() - 1;
        Iterator iterator = this.stack.iterator();
        while (iterator.hasNext()) {
            AppPrefs.storeProperty(this.properties + n, (String)iterator.next());
            --n;
        }
    }
}

