/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.damexchange;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;

public class Client
extends Thread {
    private char[] buffer = new char[200];
    private Socket socket;
    private BufferedReader reader;
    private DataOutputStream outputStream;
    private boolean threadSuspended;

    public void run() {
        this.socket = null;
        this.reader = null;
        this.threadSuspended = true;
        try {
            this.socket = new Socket("localhost", 27531);
            this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            this.outputStream = new DataOutputStream(this.socket.getOutputStream());
            while (!this.socket.isInputShutdown() && this.reader.ready()) {
                int n = this.reader.read(this.buffer);
                if (n == -1) continue;
                System.out.println(String.valueOf(this.buffer, 0, n));
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.cleanup();
        }
    }

    private void cleanup() {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (this.outputStream != null) {
            try {
                this.outputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void terminateConnection() throws IOException {
        if (this.socket != null && !this.socket.isClosed()) {
            this.cleanup();
        }
    }

    private boolean isConnected() {
        return this.socket != null && this.socket.isConnected();
    }

    public void sendMessage(String string) throws IOException {
        if (this.isConnected() && this.outputStream != null) {
            this.outputStream.write(string.getBytes());
            this.outputStream.writeByte(0);
            this.outputStream.flush();
        } else {
            System.out.println("Already disconnected");
        }
    }

    public static void main(String[] stringArray) throws IOException {
        Client client = new Client();
        client.start();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        client.sendMessage("MSG002");
        client.cleanup();
    }
}

