/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.damexchange;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.util.logging.Logger;
import net.damaq.damexchange.ConnectionProvider;
import net.damaq.damexchange.ConnectionSocketThread;
import net.damaq.utilities.LogUtils;

public class ClientConnection
extends ConnectionSocketThread {
    private static final Logger logger = Logger.getLogger(ConnectionSocketThread.class.getName());
    private final String address;

    public ClientConnection(ConnectionProvider connectionProvider, String string, int n) {
        super(connectionProvider, n);
        this.address = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.reader = null;
        this.outputStream = null;
        logger.info("ClientConnection Thread run");
        try {
            this.provider.onConnecting(this);
            this.socket = new Socket(this.address, this.port);
            this.socket.setSoLinger(true, 10000);
            logger.info("ClientConnection connected");
            this.openStreams();
            this.provider.onConnect(this);
            this.doReading();
            this.provider.onDisconnect(this);
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            if (!this.isInterrupted()) {
                LogUtils.processException(logger, iOException);
                this.provider.error(this, iOException);
            }
        }
        finally {
            this.cleanUpSocket();
            this.provider.onClientClosed(this);
            this.provider.connectionFree();
            this.socket = null;
            this.provider = null;
            logger.info("ClientConnection Thread destroying");
        }
    }

    public void terminateConnection() throws IOException {
        if (this.socket != null && !this.socket.isClosed()) {
            this.interrupt();
            this.cleanUpSocket();
        }
    }

    public boolean isServer() {
        return false;
    }
}

