/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.damexchange;

import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;
import net.damaq.damexchange.ClientConnection;
import net.damaq.damexchange.ConnectionEvent;
import net.damaq.damexchange.ConnectionListener;
import net.damaq.damexchange.ConnectionSocketThread;
import net.damaq.damexchange.ServerConnection;

public class ConnectionProvider {
    private static final Logger logger = Logger.getLogger(ConnectionProvider.class.getName());
    private final EventListenerList connectionListeners = new EventListenerList();
    private ConnectionSocketThread connection = null;

    public void createServer(int n) {
        if (this.connection != null) {
            throw new IllegalStateException("Active connection already exists");
        }
        this.connection = new ServerConnection(this, n);
        this.connection.start();
    }

    public void connectTo(String string, int n) {
        if (this.connection != null) {
            throw new IllegalStateException("Active connection already exists");
        }
        this.connection = new ClientConnection(this, string, n);
        this.connection.start();
    }

    public boolean isConnected() {
        return this.connection != null && this.connection.isConnected();
    }

    public void terminateConnection() throws IOException {
        if (this.isBound()) {
            this.connection.terminateConnection();
            this.connection = null;
        }
    }

    public boolean isServer() {
        if (this.connection == null) {
            throw new IllegalStateException("No connection adapted");
        }
        return this.connection.isServer();
    }

    public void sendMessage(String string) throws IOException {
        if (this.isConnected()) {
            this.connection.sendMessage(string);
        }
    }

    public final void addConnectionListener(ConnectionListener connectionListener) {
        this.connectionListeners.add(ConnectionListener.class, connectionListener);
    }

    public final void removeConnectionListener(ConnectionListener connectionListener) {
        this.connectionListeners.remove(ConnectionListener.class, connectionListener);
    }

    private void fireSocketEvent(ConnectionSocketThread connectionSocketThread, ConnectionEvent.SocketEventID socketEventID) {
        Object[] objectArray = this.connectionListeners.getListenerList();
        ConnectionEvent connectionEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ConnectionListener.class) continue;
            if (connectionEvent == null) {
                connectionEvent = new ConnectionEvent(this, socketEventID, connectionSocketThread);
            }
            ((ConnectionListener)objectArray[i + 1]).onSocketEvent(connectionEvent);
        }
    }

    void newMessage(ConnectionSocketThread connectionSocketThread, String string) {
        this.fireMessageEvent(connectionSocketThread, string);
    }

    private void fireErrorEvent(ConnectionSocketThread connectionSocketThread, IOException iOException) {
        Object[] objectArray = this.connectionListeners.getListenerList();
        ConnectionEvent connectionEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ConnectionListener.class) continue;
            if (connectionEvent == null) {
                connectionEvent = new ConnectionEvent(this, ConnectionEvent.SocketEventID.ERROR, connectionSocketThread);
            }
            ((ConnectionListener)objectArray[i + 1]).onError(connectionEvent, iOException);
        }
    }

    private void fireMessageEvent(ConnectionSocketThread connectionSocketThread, String string) {
        Object[] objectArray = this.connectionListeners.getListenerList();
        ConnectionEvent connectionEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ConnectionListener.class) continue;
            if (connectionEvent == null) {
                connectionEvent = new ConnectionEvent(this, ConnectionEvent.SocketEventID.MESSAGE, connectionSocketThread);
            }
            ((ConnectionListener)objectArray[i + 1]).onMessage(connectionEvent, string);
        }
    }

    void serverStarted(ConnectionSocketThread connectionSocketThread) {
        logger.info("DEx:Server started");
        this.fireSocketEvent(connectionSocketThread, ConnectionEvent.SocketEventID.SERVER_STARTED);
    }

    void serverInit(ConnectionSocketThread connectionSocketThread) {
        logger.info("DEx:Server validate");
        this.fireSocketEvent(connectionSocketThread, ConnectionEvent.SocketEventID.SERVER_INIT);
    }

    void clientConnect(ConnectionSocketThread connectionSocketThread) {
        logger.info("DEx:Client connect");
        this.fireSocketEvent(connectionSocketThread, ConnectionEvent.SocketEventID.CLIENT_CONNECT);
    }

    void serverSocketAccept(ConnectionSocketThread connectionSocketThread) {
        logger.info("DEx:Server accept");
        this.fireSocketEvent(connectionSocketThread, ConnectionEvent.SocketEventID.SERVER_ACCEPT);
    }

    void clientDisconnect(ConnectionSocketThread connectionSocketThread) {
        logger.info("DEx:Client disconnect");
        this.fireSocketEvent(connectionSocketThread, ConnectionEvent.SocketEventID.CLIENT_DISCONNECT);
    }

    void serverClosed(ConnectionSocketThread connectionSocketThread) {
        logger.info("DEx:Server closed");
        this.fireSocketEvent(connectionSocketThread, ConnectionEvent.SocketEventID.SERVER_CLOSED);
    }

    void error(ConnectionSocketThread connectionSocketThread, IOException iOException) {
        logger.info("DEx:Connection error");
        this.fireErrorEvent(connectionSocketThread, iOException);
    }

    public void onConnecting(ClientConnection clientConnection) {
        logger.info("DEx:Client connecting");
        this.fireSocketEvent(clientConnection, ConnectionEvent.SocketEventID.CONNECTING);
    }

    public void onConnect(ClientConnection clientConnection) {
        logger.info("DEx:Client connected");
        this.fireSocketEvent(clientConnection, ConnectionEvent.SocketEventID.CONNECT);
    }

    public void onDisconnect(ClientConnection clientConnection) {
        logger.info("DEx:Client disconnected");
        this.fireSocketEvent(clientConnection, ConnectionEvent.SocketEventID.DISCONNECT);
    }

    public void onClientClosed(ClientConnection clientConnection) {
        logger.info("DEx:Client terminated");
        this.fireSocketEvent(clientConnection, ConnectionEvent.SocketEventID.CLIENT_CLOSED);
    }

    public void connectionFree() {
        this.connection = null;
    }

    public boolean isBound() {
        return this.connection != null;
    }
}

