/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.damexchange;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import java.util.logging.Logger;
import net.damaq.damexchange.ConnectionProvider;
import net.damaq.utilities.LogUtils;

public abstract class ConnectionSocketThread
extends Thread {
    private static final Logger logger = Logger.getLogger(ConnectionSocketThread.class.getName());
    protected Socket socket;
    protected DataOutputStream outputStream;
    protected BufferedReader reader;
    protected ConnectionProvider provider;
    protected int port;
    private char[] buffer = new char[200];

    protected ConnectionSocketThread(ConnectionProvider connectionProvider, int n) {
        this.port = n;
        this.provider = connectionProvider;
    }

    public abstract void run();

    public boolean isConnected() {
        return this.socket != null && this.socket.isConnected();
    }

    public abstract void terminateConnection() throws IOException;

    public abstract boolean isServer();

    public void sendMessage(String string) throws IOException {
        if (this.isConnected() && this.outputStream != null) {
            this.outputStream.write(string.getBytes());
            this.outputStream.writeByte(0);
            this.outputStream.flush();
        }
    }

    protected void openStreams() throws IOException {
        this.outputStream = new DataOutputStream(this.socket.getOutputStream());
        this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()), this.buffer.length);
    }

    protected void doReading() throws IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        do {
            if ((n = this.reader.read(this.buffer)) == -1) continue;
            this.processString(stringBuilder, this.buffer, n);
        } while (this.reader.ready() || n != -1);
    }

    private void processString(StringBuilder stringBuilder, char[] cArray, int n) {
        int n2;
        int n3 = 0;
        logger.info("Received " + String.valueOf(cArray, 0, n));
        for (n2 = 0; n2 < n; ++n2) {
            if (cArray[n2] != '\u0000') continue;
            stringBuilder.append(cArray, n3, n2 - n3);
            this.provider.newMessage(this, stringBuilder.toString());
            stringBuilder.setLength(0);
            n3 = n2 + 1;
        }
        if (n3 != n2) {
            stringBuilder.append(cArray, n3, n - n3);
        }
    }

    protected void cleanUpSocket() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                LogUtils.processException(logger, iOException);
            }
        }
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException iOException) {
                LogUtils.processException(logger, iOException);
            }
        }
        if (this.outputStream != null) {
            try {
                this.outputStream.close();
            }
            catch (IOException iOException) {
                LogUtils.processException(logger, iOException);
            }
        }
    }

    public Socket getSocket() {
        return this.socket;
    }
}

