/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.damexchange;

import java.util.regex.Pattern;
import net.damaq.damexchange.messages.InvalidMessageException;

public abstract class DamExMessage {
    protected String stringValue;

    public DamExMessage() {
    }

    protected DamExMessage(String string) {
        this.stringValue = string;
    }

    public void validate() throws InvalidMessageException {
        if (this.stringValue == null) {
            throw new IllegalArgumentException("String value cannot be null");
        }
        if (!this.getMsgPattern().matcher(this.stringValue).matches()) {
            throw new InvalidMessageException("Invalid DamExchange 1.0 message:" + this.stringValue);
        }
        this.parse(this.stringValue);
    }

    protected abstract void parse(String var1) throws InvalidMessageException;

    protected abstract Pattern getMsgPattern();

    public abstract char getCode();

    public String getStringValue() {
        return this.stringValue;
    }

    public void setStringValue(String string) {
        this.stringValue = string;
    }

    public String toString() {
        return this.getStringValue();
    }
}

