/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.damexchange;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import net.damaq.damexchange.ConnectionEvent;
import net.damaq.damexchange.ConnectionListener;
import net.damaq.damexchange.ConnectionProvider;
import net.damaq.damexchange.DamExMessage;
import net.damaq.damexchange.DamExchangeMsgEvent;
import net.damaq.damexchange.DamExchangeMsgListener;
import net.damaq.damexchange.messages.ChatMessage;
import net.damaq.damexchange.messages.GameAccMessage;
import net.damaq.damexchange.messages.GameEndMessage;
import net.damaq.damexchange.messages.GameReqMessage;
import net.damaq.damexchange.messages.InvalidMessage;
import net.damaq.damexchange.messages.InvalidMessageException;
import net.damaq.damexchange.messages.MoveMessage;
import net.damaq.dialogs.damexchange.DamExchangeDialog;
import net.damaq.gamestyle.interfaces.Move;
import net.damaq.utilities.LogUtils;
import net.damaq.utilities.Swinger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DamExchangeManager
implements ConnectionListener {
    private static final Logger logger = Logger.getLogger(DamExchangeManager.class.getName());
    private ConnectionProvider provider = new ConnectionProvider();
    private final EventListenerList listenerList = new EventListenerList();
    private DamExchangeDialog activeDialog;
    private GameReqMessage gameReqMessage = null;
    public static final int STATE_DISCONNECTED = -2;
    public static final int STATE_BOUND = -1;
    public static final int STATE_INETGAME = 0;
    public static final int STATE_GAME_NEGOTIATE = 1;
    public static final int STATE_PLAYING = 2;
    private int state = -2;
    private DamExMessage savedMoveMessage;

    public DamExchangeManager() {
        this.provider.addConnectionListener(this);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listenerList.add(PropertyChangeListener.class, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listenerList.remove(PropertyChangeListener.class, propertyChangeListener);
    }

    public void addDamExchangeMsgListener(DamExchangeMsgListener damExchangeMsgListener) {
        this.listenerList.add(DamExchangeMsgListener.class, damExchangeMsgListener);
    }

    public void removeDamExchangeMsgListener(DamExchangeMsgListener damExchangeMsgListener) {
        this.listenerList.remove(DamExchangeMsgListener.class, damExchangeMsgListener);
    }

    @Override
    public void onSocketEvent(ConnectionEvent connectionEvent) {
        switch (connectionEvent.getId()) {
            case SERVER_STARTED: {
                this.setState(-1);
                break;
            }
            case CONNECT: 
            case CLIENT_CONNECT: {
                this.setState(0);
                break;
            }
            case DISCONNECT: 
            case CLIENT_DISCONNECT: 
            case CLIENT_CLOSED: 
            case SERVER_CLOSED: {
                this.setState(-2);
                break;
            }
        }
    }

    private void setState(int n) {
        logger.info("DX: Setting state to " + n);
        if (n == 2) {
            this.resetIncomingMessage();
        }
        int n2 = this.state;
        if (this.state != n) {
            this.state = n;
            this.firePropertyEvent("inetState", n2, n);
        }
    }

    @Override
    public void onError(ConnectionEvent connectionEvent, IOException iOException) {
        this.setState(-2);
        this.closeActiveDialog();
    }

    public void waitForConnection() {
        try {
            if (!this.provider.isBound()) {
                this.provider.createServer(27531);
            }
        }
        catch (Exception exception) {
            LogUtils.processException(logger, exception);
        }
    }

    @Override
    public void onMessage(ConnectionEvent connectionEvent, String string) {
        DamExMessage damExMessage;
        logger.info("Damexchange new message:" + string);
        try {
            if (string.length() <= 1) {
                throw new InvalidMessageException("Unrecognized message");
            }
            damExMessage = this.processMessage(string);
        }
        catch (InvalidMessageException invalidMessageException) {
            LogUtils.processException(logger, invalidMessageException);
            damExMessage = new InvalidMessage(string);
        }
        final DamExMessage damExMessage2 = damExMessage;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DamExchangeManager.this.fireMessageEvent(damExMessage2, false);
            }
        });
    }

    private DamExMessage processMessage(String string) throws InvalidMessageException {
        DamExMessage damExMessage;
        char c = string.charAt(0);
        switch (c) {
            case 'M': {
                damExMessage = new MoveMessage(string);
                break;
            }
            case 'C': {
                damExMessage = new ChatMessage(string);
                break;
            }
            case 'R': {
                damExMessage = new GameReqMessage(string);
                break;
            }
            case 'E': {
                damExMessage = new GameEndMessage(string);
                break;
            }
            case 'A': {
                damExMessage = new GameAccMessage(string);
                break;
            }
            default: {
                throw new InvalidMessageException("Unrecognized message");
            }
        }
        damExMessage.validate();
        if (c == 'C') {
            return damExMessage;
        }
        block7 : switch (this.state) {
            case 1: {
                switch (c) {
                    case 'E': {
                        this.setState(0);
                        break block7;
                    }
                    case 'A': {
                        if (((GameAccMessage)damExMessage).getAcceptCode() != 0) {
                            this.setState(0);
                            break block7;
                        }
                        this.setState(2);
                        break block7;
                    }
                }
                break;
            }
            case 0: {
                switch (c) {
                    case 'R': {
                        this.setState(1);
                        this.gameReqMessage = (GameReqMessage)damExMessage;
                        break block7;
                    }
                    case 'E': {
                        break block7;
                    }
                }
                damExMessage = new InvalidMessage(string);
                this.sendMessage(new GameEndMessage(0, 0));
                break;
            }
            case 2: {
                switch (c) {
                    case 'E': {
                        this.stopGame(0);
                        break block7;
                    }
                    case 'M': {
                        this.savedMoveMessage = damExMessage;
                        break block7;
                    }
                }
                this.stopGame(0);
                damExMessage = new InvalidMessage(string);
            }
        }
        if (damExMessage.getCode() != '\u0000') {
            this.closeActiveDialog();
        }
        return damExMessage;
    }

    public void startGame(GameReqMessage gameReqMessage) {
        if (this.isPlaying()) {
            return;
        }
        this.gameReqMessage = gameReqMessage;
        this.setState(1);
        this.sendMessage(gameReqMessage);
    }

    public void stopGame(int n) {
        if (!this.isPlaying()) {
            return;
        }
        this.setState(0);
        this.sendMessage(new GameEndMessage(n, 0));
    }

    public ConnectionProvider getProvider() {
        return this.provider;
    }

    public void terminateConnection() {
        try {
            this.provider.terminateConnection();
        }
        catch (IOException iOException) {
            LogUtils.processException(logger, iOException);
        }
    }

    public boolean isInetGame() {
        return this.state != -2 && this.state != -1;
    }

    public boolean isPlaying() {
        return this.state == 2;
    }

    private void firePropertyEvent(String string, Object object, Object object2) {
        Object[] objectArray = this.listenerList.getListenerList();
        PropertyChangeEvent propertyChangeEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != PropertyChangeListener.class) continue;
            if (propertyChangeEvent == null) {
                propertyChangeEvent = new PropertyChangeEvent(this, string, object, object2);
            }
            ((PropertyChangeListener)objectArray[i + 1]).propertyChange(propertyChangeEvent);
        }
    }

    private void fireMessageEvent(DamExMessage damExMessage, boolean bl) {
        Object[] objectArray = this.listenerList.getListenerList();
        DamExchangeMsgEvent damExchangeMsgEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != DamExchangeMsgListener.class) continue;
            if (damExchangeMsgEvent == null) {
                damExchangeMsgEvent = new DamExchangeMsgEvent(this, damExMessage, bl);
            }
            ((DamExchangeMsgListener)objectArray[i + 1]).messageReceived(damExchangeMsgEvent);
        }
    }

    public void invalidMoveMessage(MoveMessage moveMessage) {
        this.firePropertyEvent("invalidmove", null, moveMessage);
        this.stopGame(0);
    }

    public boolean sendMessage(final DamExMessage damExMessage) {
        if (!this.isInetGame()) {
            return false;
        }
        logger.info("DEx:Sending message: " + damExMessage);
        try {
            this.provider.sendMessage(damExMessage.toString());
        }
        catch (IOException iOException) {
            this.gameReqMessage = null;
            LogUtils.processException(logger, iOException);
            return false;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DamExchangeManager.this.fireMessageEvent(damExMessage, true);
            }
        });
        return true;
    }

    public void connectTo(String string) {
        if (!this.isBound()) {
            this.provider.connectTo(string, 27531);
        }
    }

    public boolean isBound() {
        return this.state != -2;
    }

    public static void main(String[] stringArray) {
        LogUtils.initLogging(true);
        DamExchangeManager damExchangeManager = new DamExchangeManager();
        Swinger.sleep(5000);
        damExchangeManager.connectTo("localhost");
    }

    public synchronized void setActiveDialog(DamExchangeDialog damExchangeDialog) {
        this.activeDialog = damExchangeDialog;
    }

    public synchronized void removeActiveDialog(DamExchangeDialog damExchangeDialog) {
        if (damExchangeDialog != this.activeDialog && this.activeDialog != null) {
            throw new IllegalStateException("Registered dialog mismatch");
        }
        this.activeDialog = null;
    }

    public synchronized void closeActiveDialog() {
        if (this.activeDialog != null) {
            this.activeDialog.doClose(-1);
            this.activeDialog = null;
        }
    }

    public void sendChatMessage(String string) {
        ChatMessage chatMessage = new ChatMessage();
        chatMessage.setMessage(string);
        this.sendMessage(chatMessage);
    }

    public void sendMove(int n, Move move, int[] nArray) {
    }

    public void sendMove(int n, Move move, List<Integer> list) {
        if (!this.isPlaying()) {
            return;
        }
        MoveMessage moveMessage = new MoveMessage(n, move.getFirstPosition(), move.getLastPosition(), list);
        this.sendMessage(moveMessage);
        this.resetIncomingMessage();
    }

    public GameReqMessage getGameReqMessage() {
        return this.gameReqMessage;
    }

    public MoveMessage getSavedMoveMessage() {
        return (MoveMessage)this.savedMoveMessage;
    }

    public void resetIncomingMessage() {
        this.savedMoveMessage = null;
    }
}

