/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.damexchange;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.util.logging.Logger;
import net.damaq.damexchange.ConnectionProvider;
import net.damaq.damexchange.ConnectionSocketThread;
import net.damaq.utilities.LogUtils;

public class ServerConnection
extends ConnectionSocketThread {
    private static final Logger logger = Logger.getLogger(ServerConnection.class.getName());
    private ServerSocket serverSocket;

    public ServerConnection(ConnectionProvider connectionProvider, int n) {
        super(connectionProvider, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.serverSocket = null;
        this.reader = null;
        this.outputStream = null;
        try {
            this.provider.serverInit(this);
            this.serverSocket = new ServerSocket(this.port, 1);
            this.provider.serverStarted(this);
            do {
                this.socket = this.serverSocket.accept();
                this.socket.setSoLinger(true, 10000);
                this.provider.serverSocketAccept(this);
                this.openStreams();
                this.provider.clientConnect(this);
                this.doReading();
                this.provider.clientDisconnect(this);
                this.cleanUpSocket();
                this.socket = null;
            } while (!this.isInterrupted());
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            if (!this.isInterrupted()) {
                LogUtils.processException(logger, iOException);
                this.provider.error(this, iOException);
            }
        }
        finally {
            this.cleanUpSocket();
            this.provider.connectionFree();
            this.provider.serverClosed(this);
            this.socket = null;
            this.serverSocket = null;
            this.provider = null;
            logger.info("ServerConnection Thread destroying");
        }
    }

    public void terminateConnection() throws IOException {
        if (this.serverSocket != null && !this.serverSocket.isClosed()) {
            this.interrupt();
            this.cleanUpSocket();
        }
    }

    public boolean isServer() {
        return true;
    }

    protected void cleanUpSocket() {
        super.cleanUpSocket();
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public ServerSocket getServerSocket() {
        return this.serverSocket;
    }
}

