/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.damexchange.messages;

import java.util.regex.Pattern;
import net.damaq.damexchange.DamExMessage;
import net.damaq.damexchange.messages.InvalidMessageException;
import net.damaq.gamestyle.Side;

public class BackReqMessage
extends DamExMessage {
    private static final char CODE = 'B';
    private static final Pattern msgPattern = Pattern.compile("^B\\d\\d\\d(W|Z)$");
    private int moveNumber;
    private Side sideOnMove;

    public BackReqMessage(String string) {
        super(string);
    }

    public BackReqMessage(int n, Side side) {
        this.moveNumber = n;
        this.sideOnMove = side;
        String string = String.format("B%03d%s", n, side == Side.WHITES ? "W" : "Z");
        this.setStringValue(string);
    }

    protected void parse(String string) throws InvalidMessageException {
        this.moveNumber = Integer.parseInt(string.substring(1, 4));
        this.sideOnMove = string.charAt(4) == 'W' ? Side.WHITES : Side.BLACKS;
    }

    protected Pattern getMsgPattern() {
        return msgPattern;
    }

    public char getCode() {
        return 'B';
    }

    public int getMoveNumber() {
        return this.moveNumber;
    }

    public Side getSideOnMove() {
        return this.sideOnMove;
    }
}

