/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.damexchange.messages;

import java.util.regex.Pattern;
import net.damaq.damexchange.DamExMessage;
import net.damaq.damexchange.messages.InvalidMessageException;
import net.damaq.utilities.Utils;

public class GameAccMessage
extends DamExMessage {
    private static final char CODE = 'A';
    public static final int RESULT_GAME_ACCEPTED = 0;
    public static final int RESULT_PROTOCOL_MISMATCH = 1;
    public static final int RESULT_GAME_REJECTED = 2;
    public static final int RESULT_NO_GAME_ANYMORE = 3;
    private static final Pattern msgPattern = Pattern.compile("^A.{32}[0-3]$");
    private int acceptCode = -1;
    private String followerName;

    public GameAccMessage(String string) {
        super(string);
    }

    public GameAccMessage(int n, String string) {
        this.acceptCode = n;
        this.followerName = string;
        this.setStringValue(String.format("A%-32s%d", string, n));
    }

    protected void parse(String string) throws InvalidMessageException {
        this.followerName = Utils.trimRight(string.substring(1, 33));
        this.acceptCode = Integer.parseInt(string.substring(33, 34));
    }

    protected Pattern getMsgPattern() {
        return msgPattern;
    }

    public char getCode() {
        return 'A';
    }

    public int getAcceptCode() {
        return this.acceptCode;
    }

    public String getFollowerName() {
        return this.followerName;
    }
}

