/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.damexchange.messages;

import java.util.regex.Pattern;
import net.damaq.damexchange.DamExMessage;
import net.damaq.damexchange.messages.InvalidMessageException;
import net.damaq.gamestyle.GameStyleFactory;
import net.damaq.gamestyle.NotConvertibleException;
import net.damaq.gamestyle.Side;
import net.damaq.gamestyle.interfaces.Board;
import net.damaq.gamestyle.interfaces.GameStyle;
import net.damaq.utilities.Utils;

public class GameReqMessage
extends DamExMessage {
    private static final char CODE = 'R';
    public static final String PROTOCOL_VERSION = "01";
    private static final Pattern msgPattern = Pattern.compile("^R\\d\\d.{32}(W|Z)\\d{6}(A|B)((W|Z)(w|z|e|Z|W){50})?$");
    private String initiatorName = null;
    private Side followerColor = null;
    private int thinkingTime = -1;
    private int numberOfMoves = -1;
    private int protocolVersion = -1;
    private boolean standardStartPosition = false;
    private Board board = null;
    private boolean isInitiator = false;

    public GameReqMessage(String string) {
        super(string);
    }

    public GameReqMessage(String string, Side side, int n, int n2, Board board) {
        String string2;
        CharSequence charSequence;
        this.isInitiator = true;
        this.initiatorName = string;
        this.followerColor = side;
        this.thinkingTime = n;
        this.numberOfMoves = n2;
        this.board = board;
        boolean bl = this.standardStartPosition = board == null;
        if (!this.standardStartPosition) {
            charSequence = new StringBuilder(60);
            charSequence.append('B');
            charSequence.append(board.isSideToMove(Side.WHITES) ? (char)'W' : 'Z');
            int n3 = board.getMaxBoardLength();
            block7: for (int i = 1; i <= n3; ++i) {
                switch (board.get(i)) {
                    case BLACK_PIECE: {
                        charSequence.append('z');
                        continue block7;
                    }
                    case WHITE_PIECE: {
                        charSequence.append('w');
                        continue block7;
                    }
                    case NOTHING: {
                        charSequence.append('e');
                        continue block7;
                    }
                    case BLACK_KING: {
                        charSequence.append('Z');
                        continue block7;
                    }
                    case WHITE_KING: {
                        charSequence.append('W');
                    }
                }
            }
            string2 = charSequence.toString();
        } else {
            string2 = "A";
        }
        charSequence = String.format("R%s%-32s%s%03d%03d%s", PROTOCOL_VERSION, string, side == Side.WHITES ? "W" : "Z", n, n2, string2);
        this.setStringValue((String)charSequence);
    }

    public GameReqMessage(String string, Side side, int n, int n2) {
        this(string, side, n, n2, null);
    }

    protected Pattern getMsgPattern() {
        return msgPattern;
    }

    protected void parse(String string) throws InvalidMessageException {
        this.protocolVersion = Integer.parseInt(string.substring(1, 3));
        this.initiatorName = Utils.trimRight(string.substring(3, 35));
        this.followerColor = string.charAt(35) == 'W' ? Side.WHITES : Side.BLACKS;
        this.thinkingTime = Integer.parseInt(string.substring(36, 39));
        this.numberOfMoves = Integer.parseInt(string.substring(39, 42));
        boolean bl = this.standardStartPosition = string.charAt(42) == 'A';
        if (!this.standardStartPosition) {
            GameStyle gameStyle = GameStyleFactory.getInstance().getDefaultGameInstance();
            try {
                this.board = gameStyle.newBoardInstance(string.substring(44));
            }
            catch (NotConvertibleException notConvertibleException) {
                throw new InvalidMessageException("Invalid board description in message: " + string);
            }
            if (string.charAt(43) == 'W') {
                this.board.setSideToMove(Side.WHITES);
            } else {
                this.board.setSideToMove(Side.BLACKS);
            }
        }
    }

    public char getCode() {
        return 'R';
    }

    public String getInitiatorName() {
        return this.initiatorName;
    }

    public Side getFollowerColor() {
        return this.followerColor;
    }

    public int getThinkingTime() {
        return this.thinkingTime;
    }

    public int getNumberOfMoves() {
        return this.numberOfMoves;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public boolean isStandardStartPosition() {
        return this.standardStartPosition;
    }

    public Board getBoard() {
        return this.board;
    }

    public boolean isInitiator() {
        return this.isInitiator;
    }
}

