/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.damexchange.messages;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import net.damaq.damexchange.DamExMessage;
import net.damaq.damexchange.messages.InvalidMessageException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveMessage
extends DamExMessage {
    private static final char CODE = 'M';
    private static final Pattern msgPattern = Pattern.compile("^M\\d{10}(\\d\\d)*$");
    private int time;
    private int fromField;
    private int toField;
    private int numberCaptured = -1;
    private Set<Integer> capturedPieces = new HashSet<Integer>(5);

    public MoveMessage(String string) {
        super(string);
    }

    public MoveMessage(int n, int n2, int n3, List<Integer> list) {
        this.time = n;
        this.fromField = n2;
        this.toField = n3;
        this.numberCaptured = list.size();
        StringBuilder stringBuilder = new StringBuilder(this.numberCaptured * 2);
        this.capturedPieces.addAll(list);
        for (Integer n4 : this.capturedPieces) {
            if (n4 < 10) {
                stringBuilder.append('0');
            }
            stringBuilder.append(n4);
        }
        this.setStringValue(String.format("M%04d%02d%02d%02d%s", n, n2, n3, this.numberCaptured, stringBuilder.toString()));
    }

    @Override
    protected void parse(String string) throws InvalidMessageException {
        this.time = Integer.parseInt(string.substring(1, 5));
        this.fromField = Integer.parseInt(string.substring(5, 7));
        this.toField = Integer.parseInt(string.substring(7, 9));
        this.numberCaptured = Integer.parseInt(string.substring(9, 11));
        if (this.numberCaptured > 0) {
            for (int i = 11; i < string.length(); i += 2) {
                this.capturedPieces.add(Integer.parseInt(string.substring(i, i + 2)));
            }
        }
    }

    @Override
    protected Pattern getMsgPattern() {
        return msgPattern;
    }

    @Override
    public char getCode() {
        return 'M';
    }

    public int getTime() {
        return this.time;
    }

    public int getFromField() {
        return this.fromField;
    }

    public int getToField() {
        return this.toField;
    }

    public int getNumberCaptured() {
        return this.numberCaptured;
    }

    public Set<Integer> getCapturedPieces() {
        return this.capturedPieces;
    }
}

