/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import net.damaq.core.Lng;
import net.damaq.dialogs.AppDialog;
import net.damaq.utilities.BrowserControl;
import net.damaq.utilities.LogUtils;
import net.damaq.utilities.Swinger;

public final class AboutDialog
extends AppDialog {
    private static final Logger logger = Logger.getLogger(AboutDialog.class.getName());
    private JButton btnClose;
    private final JLabel splash = new JLabel();
    private final JLabel info = new JLabel();

    public AboutDialog(Frame frame) {
        super(frame, true);
        try {
            this.init();
        }
        catch (Exception exception) {
            LogUtils.processException(logger, exception);
        }
        Swinger.centerDialog(frame, this);
        this.setModal(true);
        this.setTitle(Lng.getLabel("dialog.about.title", "Damaq 1.01"));
        this.setDefaultCloseOperation(2);
        Swinger.playSound("sound.wav");
        this.setVisible(true);
    }

    private void doCancelButtonAction() {
        this.doClose();
    }

    protected AbstractButton getCancelButton() {
        return this.btnClose;
    }

    private void init() {
        this.setResizable(false);
        Container container = this.getContentPane();
        JPanel jPanel = new JPanel();
        container.setLayout(new BorderLayout());
        container.add((Component)this.splash, "Center");
        ImageIcon imageIcon = Swinger.getIcon("splash.jpg");
        this.splash.setIcon(imageIcon);
        if (imageIcon != null) {
            this.splash.setPreferredSize(new Dimension(imageIcon.getIconWidth(), imageIcon.getIconHeight()));
        }
        this.splash.setLayout(new BoxLayout(this.splash, 1));
        this.info.setBorder(new EmptyBorder(100, 25, 0, 0));
        this.info.setText(Lng.getLabel("dialog.about.text"));
        JLabel jLabel = new JLabel(Lng.getLabel("dialog.about.weblink", "http://wordrider.net/damaq"));
        JLabel jLabel2 = new JLabel(Lng.getLabel("dialog.about.maillink", "info@wordrider.net"));
        EmptyBorder emptyBorder = new EmptyBorder(0, 25, 0, 0);
        jLabel.setSize(50, 20);
        jLabel2.setSize(50, 20);
        jLabel.setBorder(emptyBorder);
        jLabel2.setBorder(emptyBorder);
        jLabel.addMouseListener(new URLMouseClickAdapter("http://wordrider.net/damaq"));
        jLabel2.addMouseListener(new URLMouseClickAdapter("mailto:info@wordrider.net"));
        this.splash.add(this.info);
        this.splash.add(jLabel);
        this.splash.add(jLabel2);
        this.splash.setBorder(new LineBorder(Color.BLACK, 2, true));
        container.add((Component)jPanel, "South");
        jPanel.setLayout(new GridBagLayout());
        Dimension dimension = new Dimension(80, 25);
        this.btnClose = Swinger.getButton("dialog.about.btnClose");
        this.btnClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AboutDialog.this.doCancelButtonAction();
            }
        });
        this.btnClose.setMinimumSize(dimension);
        jPanel.add((Component)this.btnClose, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 23, 4, 5), 0, 0));
        this.pack();
    }

    private final class URLMouseClickAdapter
    extends MouseAdapter {
        private String url = "";

        public URLMouseClickAdapter(String string) {
            this.url = string;
        }

        public final void mouseClicked(MouseEvent mouseEvent) {
            BrowserControl.showURL(this.url);
        }

        public final void mouseExited(MouseEvent mouseEvent) {
            ((Component)mouseEvent.getSource()).setCursor(Cursor.getDefaultCursor());
        }

        public final void mouseEntered(MouseEvent mouseEvent) {
            ((Component)mouseEvent.getSource()).setCursor(Cursor.getPredefinedCursor(12));
        }
    }
}

