/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.dialogs;

import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import net.damaq.core.Lng;
import net.damaq.core.managers.HistoryItem;
import net.damaq.gamestyle.GameStyleFactory;
import net.damaq.gamestyle.NotSupportedGameStyleException;
import net.damaq.gamestyle.Side;
import net.damaq.gamestyle.interfaces.Board;
import net.damaq.gamestyle.interfaces.GameStyle;
import net.damaq.gamestyle.interfaces.Move;
import net.damaq.pdn.PDNGame;
import net.damaq.pdn.PDNMove;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GameDetails {
    private static final Logger logger = Logger.getLogger(GameDetails.class.getName());
    private boolean validHistory;
    private List<HistoryItem> historyList = null;
    private GameStyle supportedGameStyle = null;
    private final PDNGame pdnGame;
    private String opening;
    private String stringResult;

    public GameDetails(PDNGame pDNGame) {
        this.pdnGame = pDNGame;
        this.validHistory = true;
    }

    public final boolean isValidHistory() {
        return this.validHistory;
    }

    public final List<HistoryItem> getHistoryList() {
        return this.historyList;
    }

    public final PDNGame getPdnGame() {
        return this.pdnGame;
    }

    public final GameStyle getSupportedGameStyle() {
        return this.supportedGameStyle;
    }

    private void setSupportedGameStyle(GameStyle gameStyle) {
        this.supportedGameStyle = gameStyle;
    }

    private void setHistoryList(List<HistoryItem> list) {
        this.historyList = list;
    }

    private void setValidHistory(boolean bl) {
        this.validHistory = bl;
    }

    public final String getOpening() {
        return this.opening;
    }

    public final void setOpening(String string) {
        this.opening = string;
    }

    public final String getStringResult() {
        return this.stringResult;
    }

    public final void setStringResult(String string) {
        this.stringResult = string;
    }

    public final void updateData() {
        block14: {
            switch (this.pdnGame.getResultSection().getResult()) {
                case BLACK_WINS: {
                    this.stringResult = Lng.getLabel("dialog.pdn.blackwon");
                    break;
                }
                case WHITE_WINS: {
                    this.stringResult = Lng.getLabel("dialog.pdn.whitewon");
                    break;
                }
                case DRAW: {
                    this.stringResult = Lng.getLabel("dialog.pdn.draw");
                    break;
                }
                case UNDECIDED: {
                    this.stringResult = Lng.getLabel("dialog.pdn.undecided");
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            StringBuilder stringBuilder = new StringBuilder();
            int n = 8;
            for (PDNMove object2 : this.pdnGame.getMoveList()) {
                stringBuilder.append(object2.toString());
                if (--n == 0) break;
                stringBuilder.append(" ");
            }
            this.opening = stringBuilder.toString();
            Object object = null;
            try {
                Board board;
                GameStyle notSupportedGameStyleException = GameStyleFactory.getSupportedGameStyle(this.pdnGame);
                this.setSupportedGameStyle(notSupportedGameStyleException);
                if (this.pdnGame.getFENDescription() != null) {
                    board = notSupportedGameStyleException.newBoardInstance(this.pdnGame.getFENDescription());
                } else {
                    board = notSupportedGameStyleException.newBoardInstance();
                    board.setStartPosition();
                    board.setSideToMove(Side.WHITES);
                }
                object = new LinkedList();
                HistoryItem historyItem = new HistoryItem(board);
                board = board.doCopy();
                int[] nArray = historyItem.getCounts();
                int n2 = notSupportedGameStyleException.maxPiecesForSide();
                if (nArray[0] > n2 || nArray[1] > n2) {
                    throw new NotSupportedGameStyleException("Illegal start position");
                }
                object.add(historyItem);
                for (PDNMove pDNMove : this.pdnGame.getMoveList()) {
                    if (pDNMove.isBlackStarts()) continue;
                    Move move = notSupportedGameStyleException.newMoveInstance(board, pDNMove);
                    board = board.doCopy();
                    List<Integer> list = board.doMove(move, true);
                    historyItem.setMove(move, list);
                    historyItem.setComment(pDNMove.getComment());
                    historyItem = new HistoryItem(board);
                    object.add(historyItem);
                }
                this.setHistoryList((List<HistoryItem>)object);
                this.setValidHistory(true);
            }
            catch (NotSupportedGameStyleException notSupportedGameStyleException) {
                logger.warning(notSupportedGameStyleException.getMessage());
                this.setValidHistory(false);
                if (object == null) break block14;
                object.clear();
            }
        }
    }
}

