/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import net.damaq.core.Lng;
import net.damaq.dialogs.AppDialog;
import net.damaq.utilities.LogUtils;
import net.damaq.utilities.Swinger;

public final class LoadingDialog
extends AppDialog {
    private final JProgressBar progressBar = new JProgressBar();
    private JPanel showPanel;
    private static final Logger logger = Logger.getLogger(LoadingDialog.class.getName());

    public LoadingDialog(Frame frame) {
        super(frame, true);
        try {
            this.init();
        }
        catch (Exception exception) {
            LogUtils.processException(logger, exception);
        }
        Swinger.centerDialog(frame, this);
        this.setResizable(false);
        this.setModal(true);
        this.setDefaultCloseOperation(2);
    }

    private void init() {
        this.setUndecorated(true);
        Container container = this.getContentPane();
        container.setCursor(Cursor.getPredefinedCursor(3));
        this.showPanel = new JPanel(new BorderLayout());
        container.add(this.showPanel);
        this.progressBar.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.showPanel.add((Component)this.progressBar, "Center");
        this.showPanel.setBorder(BorderFactory.createEmptyBorder(5, 7, 5, 7));
        this.showPanel.setMinimumSize(new Dimension(200, 30));
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(false);
    }

    public final JProgressBar getProgressBar() {
        return this.progressBar;
    }

    public final void setStatusText(String string) {
        this.progressBar.setString(string);
        int n = this.progressBar.getFontMetrics(this.progressBar.getFont()).stringWidth(string);
        this.showPanel.setPreferredSize(new Dimension(n + 30, 30));
        this.showPanel.revalidate();
        this.pack();
    }

    public final void setTitle(String string) {
        this.showPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Lng.getLabel(string)));
        this.pack();
    }
}

