/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.dialogs;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.VolatileImage;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import net.damaq.core.Lng;
import net.damaq.gamestyle.Piece;
import net.damaq.gamestyle.interfaces.Board;
import net.damaq.utilities.Swinger;

public final class PreviewDrawBoard
extends JComponent {
    private VolatileImage buffer = null;
    private boolean contentsLost = false;
    private Rectangle contentRect;
    private Board board = null;
    private int boardWidth = 0;
    private int sqWidth = 0;
    private boolean rebuildBuffer;
    private Image whitePiece;
    private Image blackPiece;
    private Image whiteKing;
    private Image blackKing;
    private Image blackBar;
    private Image whiteBar;
    private FontMetrics fm;
    private static final String PREVIEW_IS_NOT_AVAILABLE = Lng.getLabel("dialog.pdn.previewNA");
    private boolean imageExport = false;

    public PreviewDrawBoard() {
        this.init(false);
    }

    public PreviewDrawBoard(boolean bl) {
        this.init(bl);
    }

    private void init(boolean bl) {
        this.imageExport = bl;
        this.setLayout(new FlowLayout());
        if (this.imageExport) {
            this.setBorder(BorderFactory.createEtchedBorder());
        } else {
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createEtchedBorder()));
        }
        this.whitePiece = Swinger.getIconImage("sq_wp.gif");
        this.blackPiece = Swinger.getIconImage("sq_bp.gif");
        this.whiteKing = Swinger.getIconImage("sq_wk.gif");
        this.blackKing = Swinger.getIconImage("sq_bk.gif");
        this.blackBar = Swinger.getIconImage("sq_bb.gif");
        this.whiteBar = Swinger.getIconImage("sq_wb.gif");
        this.sqWidth = this.whiteBar.getWidth(null);
        this.fm = this.getFontMetrics(new Font("Dialog", 0, 12));
    }

    private void paintBoard(Graphics graphics) {
        int n = 1;
        for (int i = 0; i < this.boardWidth; ++i) {
            int n2 = 0;
            for (int j = 0; j < this.boardWidth; ++j) {
                if ((j & 1) != (i & 1)) {
                    graphics.drawImage(this.getImage(this.board.get(n)), 0, 0, this);
                    ++n;
                } else {
                    graphics.drawImage(this.whiteBar, 0, 0, null);
                }
                graphics.translate(this.sqWidth, 0);
                n2 += this.sqWidth;
            }
            graphics.translate(-n2, this.sqWidth);
        }
    }

    public final synchronized void setBoard(Board board) {
        Insets insets = this.getInsets();
        this.contentRect = board == null ? new Rectangle(insets.left, insets.top, 200, 200) : new Rectangle(insets.left, insets.top, board.getBoardWidth() * this.sqWidth, board.getBoardWidth() * this.sqWidth);
        Dimension dimension = new Dimension(insets.left + insets.right + this.contentRect.width, insets.bottom + insets.top + this.contentRect.width);
        this.setPreferredSize(dimension);
        if (board != null) {
            this.boardWidth = board.getBoardWidth();
        }
        this.board = board;
        this.rebuildBuffer = true;
        this.repaintContent();
    }

    private void renderOffscreen(boolean bl) {
        do {
            if (bl || this.buffer == null || this.buffer.validate(this.getGraphicsConfiguration()) == 2) {
                this.buffer = this.createVolatileImage(this.contentRect.width, this.contentRect.width);
            }
            Graphics2D graphics2D = this.buffer.createGraphics();
            this.paintBoard(graphics2D);
            graphics2D.dispose();
        } while (this.buffer.contentsLost());
    }

    public final void paintComponent(Graphics graphics) {
        if (this.board == null) {
            super.paintComponent(graphics);
            graphics.setColor(Color.GRAY);
            int n = this.fm.stringWidth(PREVIEW_IS_NOT_AVAILABLE);
            graphics.drawString(PREVIEW_IS_NOT_AVAILABLE, (this.contentRect.width - n) / 2, (this.contentRect.height - 5) / 2);
            return;
        }
        if (this.imageExport) {
            this.paintGraphics(graphics);
            return;
        }
        do {
            if (this.buffer == null || this.rebuildBuffer) {
                this.renderOffscreen(true);
                this.rebuildBuffer = false;
            } else if (this.buffer.contentsLost() || this.contentsLost) {
                this.renderOffscreen(false);
                this.contentsLost = false;
            } else {
                int n = this.buffer.validate(this.getGraphicsConfiguration());
                if (n == 1) {
                    this.renderOffscreen(false);
                } else if (n == 2) {
                    this.renderOffscreen(true);
                }
            }
            graphics.drawImage(this.buffer, this.contentRect.x, this.contentRect.y, null);
        } while (this.buffer.contentsLost() || this.contentsLost);
    }

    private void repaintContent() {
        if (this.buffer != null) {
            this.contentsLost = true;
            this.buffer.flush();
        }
        this.repaint();
    }

    public void paintGraphics(Graphics graphics) {
        BufferedImage bufferedImage = new BufferedImage(this.contentRect.width, this.contentRect.width, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        this.paintBoard(graphics2D);
        graphics.drawImage(bufferedImage, this.contentRect.x, this.contentRect.y, null);
        graphics2D.dispose();
    }

    public final void dispose() {
        if (this.buffer != null) {
            this.buffer.flush();
        }
        if (this.whitePiece != null) {
            this.whitePiece.flush();
        }
        if (this.blackPiece != null) {
            this.blackPiece.flush();
        }
        if (this.whiteKing != null) {
            this.whiteKing.flush();
        }
        if (this.blackBar != null) {
            this.blackBar.flush();
        }
        if (this.whiteBar != null) {
            this.whiteBar.flush();
        }
        if (this.blackKing != null) {
            this.blackKing.flush();
        }
    }

    private Image getImage(Piece piece) {
        switch (piece) {
            case WHITE_PIECE: {
                return this.whitePiece;
            }
            case BLACK_PIECE: {
                return this.blackPiece;
            }
            case NOTHING: {
                return this.blackBar;
            }
            case BLACK_KING: {
                return this.blackKing;
            }
            case WHITE_KING: {
                return this.whiteKing;
            }
        }
        return null;
    }
}

