/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.dialogs;

import java.io.File;
import javax.swing.filechooser.FileFilter;
import net.damaq.core.Lng;
import net.damaq.core.actions.interfaces.IFileType;
import net.damaq.utilities.Utils;

public final class RiderFileFilter
extends FileFilter
implements IFileType {
    private final Object[] extensions;
    private final String description;
    private boolean rewrite;

    public RiderFileFilter(String[] stringArray, String string) {
        this(stringArray, string, false);
    }

    public RiderFileFilter(String[] stringArray, String string, boolean bl) {
        this.extensions = stringArray;
        this.rewrite = bl;
        StringBuilder stringBuilder = new StringBuilder();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("*.").append(stringArray[i]);
            if (i + 1 == n) continue;
            stringBuilder.append(',');
        }
        this.description = Lng.getLabel(string, stringArray[0].toUpperCase(), stringBuilder.toString());
    }

    public final String getExtension() {
        return this.extensions[0].toString();
    }

    public final boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        String string = Utils.getExtension(file);
        if (string != null) {
            for (int i = 0; i < this.extensions.length; ++i) {
                if (!string.equals(this.extensions[i])) continue;
                return true;
            }
        }
        return false;
    }

    public boolean askForRewrite() {
        return this.rewrite;
    }

    public final String getDescription() {
        return this.description;
    }
}

