/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.dialogs;

import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import net.damaq.core.Lng;
import net.damaq.core.managers.TimeManager;
import net.damaq.core.swing.CustomLayoutConstraints;
import net.damaq.dialogs.AppDialog;
import net.damaq.dialogs.layouts.EqualsLayout;
import net.damaq.utilities.LogUtils;
import net.damaq.utilities.Swinger;

public final class TimerSetDialog
extends AppDialog {
    private static final Logger logger = Logger.getLogger(TimerSetDialog.class.getName());
    private final JButton btnSave = Swinger.getButton("dialog.timer.btnSave");
    private final JButton btnCancel = Swinger.getButton("dialog.timer.btnCancel");
    private final TimeManager timeManager;
    private final boolean wasRunning;
    private JSpinner spinnerWhiteHour;
    private JSpinner spinnerWhiteMinute;
    private JSpinner spinnerWhiteSecond;
    private JSpinner spinnerBlackHour;
    private JSpinner spinnerBlackMinute;
    private JSpinner spinnerBlackSecond;

    public TimerSetDialog(Frame frame, TimeManager timeManager) {
        super(frame, true);
        this.timeManager = timeManager;
        if (timeManager.isRunning()) {
            this.wasRunning = true;
            timeManager.stop();
        } else {
            this.wasRunning = false;
        }
        try {
            this.init();
        }
        catch (Exception exception) {
            LogUtils.processException(logger, exception);
        }
        Swinger.centerDialog(frame, this);
        this.setModal(true);
        this.setTitle(Lng.getLabel("dialog.timer.title"));
        this.setDefaultCloseOperation(2);
        this.setVisible(true);
    }

    public void doClose() {
        super.doClose();
        if (this.wasRunning) {
            this.timeManager.start();
        }
    }

    protected AbstractButton getCancelButton() {
        return this.btnCancel;
    }

    protected AbstractButton getOkButton() {
        return this.btnSave;
    }

    private void init() {
        this.setResizable(true);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        TableLayout tableLayout = new TableLayout(new double[]{-1.0, -2.0, -2.0, -1.0}, new double[]{-2.0, -2.0, -1.0});
        tableLayout.setHGap(4);
        tableLayout.setVGap(1);
        JPanel jPanel = new JPanel(tableLayout);
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(4, 4, 4, 4))));
        JLabel jLabel = Swinger.getLabel("dialog.timer.labelWhite");
        JLabel jLabel2 = Swinger.getLabel("dialog.timer.labelBlack");
        TimeManager.TimeValues timeValues = this.timeManager.getTime();
        jPanel.add((Component)jLabel, new CustomLayoutConstraints(1, 0));
        jPanel.add((Component)this.getTimePanel(timeValues.totalWhite, true), new CustomLayoutConstraints(2, 0));
        jPanel.add((Component)jLabel2, new CustomLayoutConstraints(1, 1));
        jPanel.add((Component)this.getTimePanel(timeValues.totalBlack, false), new CustomLayoutConstraints(2, 1));
        jLabel.setLabelFor(this.spinnerWhiteHour);
        jLabel2.setLabelFor(this.spinnerBlackHour);
        JPanel jPanel2 = new JPanel(new EqualsLayout(5));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 6));
        jPanel2.setPreferredSize(new Dimension(239, 32));
        Dimension dimension = new Dimension(75, 25);
        this.btnCancel.setMinimumSize(dimension);
        this.btnSave.setMinimumSize(dimension);
        jPanel2.add(this.btnSave);
        jPanel2.add(this.btnCancel);
        this.btnSave.addActionListener(new SetTimeAction());
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TimerSetDialog.this.doClose();
            }
        });
        container.add((Component)jPanel, "Center");
        container.add((Component)jPanel2, "South");
        this.pack();
    }

    private JPanel getTimePanel(int n, boolean bl) {
        JSpinner jSpinner;
        JSpinner jSpinner2;
        JSpinner jSpinner3;
        int n2 = n / 3600;
        int n3 = (n -= 3600 * n2) / 60;
        int n4 = n - 60 * n3;
        TableLayout tableLayout = new TableLayout(new double[]{-2.0, -2.0, -2.0, -2.0, -2.0}, new double[]{-1.0});
        tableLayout.setHGap(3);
        tableLayout.setVGap(2);
        JPanel jPanel = new JPanel(tableLayout);
        if (bl) {
            jSpinner3 = this.spinnerWhiteHour = this.getSpinner(n2, 99);
            jSpinner2 = this.spinnerWhiteMinute = this.getSpinner(n3, 59);
            jSpinner = this.spinnerWhiteSecond = this.getSpinner(n4, 59);
        } else {
            jSpinner3 = this.spinnerBlackHour = this.getSpinner(n2, 99);
            jSpinner2 = this.spinnerBlackMinute = this.getSpinner(n3, 59);
            jSpinner = this.spinnerBlackSecond = this.getSpinner(n4, 59);
        }
        jPanel.add((Component)jSpinner3, new CustomLayoutConstraints(0, 0));
        jPanel.add((Component)new JLabel(":"), new CustomLayoutConstraints(1, 0));
        jPanel.add((Component)jSpinner2, new CustomLayoutConstraints(2, 0));
        jPanel.add((Component)new JLabel(":"), new CustomLayoutConstraints(3, 0));
        jPanel.add((Component)jSpinner, new CustomLayoutConstraints(4, 0));
        return jPanel;
    }

    private JSpinner getSpinner(int n, int n2) {
        JSpinner jSpinner = new JSpinner(new SpinnerNumberModel(n, 0, n2, 1));
        ((JSpinner.NumberEditor)jSpinner.getEditor()).getFormat().setMinimumIntegerDigits(2);
        jSpinner.setValue(n);
        return jSpinner;
    }

    private class SetTimeAction
    implements ActionListener {
        private SetTimeAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TimeManager.TimeValues timeValues = new TimeManager.TimeValues();
            timeValues.totalWhite = (Integer)TimerSetDialog.this.spinnerWhiteHour.getValue() * 3600 + (Integer)TimerSetDialog.this.spinnerWhiteMinute.getValue() * 60 + (Integer)TimerSetDialog.this.spinnerWhiteSecond.getValue();
            timeValues.totalBlack = (Integer)TimerSetDialog.this.spinnerBlackHour.getValue() * 3600 + (Integer)TimerSetDialog.this.spinnerBlackMinute.getValue() * 60 + (Integer)TimerSetDialog.this.spinnerBlackSecond.getValue();
            TimerSetDialog.this.timeManager.setTime(timeValues);
            TimerSetDialog.this.doClose();
        }
    }
}

