/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.dialogs.damexchange;

import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import net.damaq.core.Lng;
import net.damaq.core.MainApp;
import net.damaq.core.managers.Game;
import net.damaq.core.swing.CustomLayoutConstraints;
import net.damaq.core.swing.JButtonGroup;
import net.damaq.damexchange.messages.GameReqMessage;
import net.damaq.dialogs.LimitedPlainDocument;
import net.damaq.dialogs.PreviewDrawBoard;
import net.damaq.dialogs.damexchange.DamExchangeDialog;
import net.damaq.dialogs.layouts.EqualsLayout;
import net.damaq.gamestyle.Side;
import net.damaq.gamestyle.interfaces.Board;
import net.damaq.utilities.LogUtils;
import net.damaq.utilities.Swinger;

public class NewGameDialog
extends DamExchangeDialog {
    private static final Logger logger = Logger.getLogger(NewGameDialog.class.getName());
    private GameReqMessage reqMessage;
    private final boolean accept;
    private final JButton btnSave = Swinger.getButton("dialog.timer.btnSave");
    private final JButton btnCancel = Swinger.getButton("dialog.timer.btnCancel");
    final JRadioButton radioWhite = Swinger.getRadio("asdasd");
    final JRadioButton radioBlack = Swinger.getRadio("asdasd");
    final JRadioButton radioStartingPosition = Swinger.getRadio("asdasd");
    final JRadioButton radioCurrentPosition = Swinger.getRadio("asdasd");
    private final PreviewDrawBoard previewDrawBoard = new PreviewDrawBoard(false);
    private final Board startingBoard;
    private JTextField fieldNickname;
    private JSpinner spinnerMoves;
    private JSpinner spinnerTime;

    public NewGameDialog(Frame frame, Game game, GameReqMessage gameReqMessage, boolean bl) throws HeadlessException {
        super(frame, true);
        this.reqMessage = gameReqMessage;
        this.accept = bl;
        this.startingBoard = game.getManager().getCurrentGameStyle().newStartBoard();
        try {
            this.init();
        }
        catch (Exception exception) {
            LogUtils.processException(logger, exception);
        }
        Swinger.centerDialog(frame, this);
        this.setModal(true);
        this.pack();
        this.setTitle(Lng.getLabel("dialog.timer.title"));
        this.setDefaultCloseOperation(2);
    }

    private void init() {
        this.setResizable(true);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        TableLayout tableLayout = new TableLayout(new double[]{-2.0, -2.0, -2.0, -2.0, -2.0, -1.0}, new double[]{-2.0, -2.0, -2.0, -2.0, -2.0, -1.0});
        tableLayout.setHGap(4);
        tableLayout.setVGap(1);
        JPanel jPanel = new JPanel(tableLayout);
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 0, 0), BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(4, 4, 4, 4))));
        JLabel jLabel = Swinger.getLabel("dialog.timer.labelWhite");
        JLabel jLabel2 = Swinger.getLabel("dialog.timer.labelBlack");
        JLabel jLabel3 = Swinger.getLabel("dialog.timer.labelBlack");
        JLabel jLabel4 = Swinger.getLabel("dialog.timer.labelBlack");
        JLabel jLabel5 = Swinger.getLabel("dialog.timer.labelBlack");
        JLabel jLabel6 = Swinger.getLabel("dialog.timer.labelBlack");
        this.fieldNickname = new JTextField();
        this.fieldNickname.setDocument(new LimitedPlainDocument(".{0,32}"));
        this.fieldNickname.setText(this.reqMessage.getInitiatorName());
        this.spinnerMoves = this.getSpinner(this.reqMessage.getNumberOfMoves(), 999);
        Dimension dimension = this.spinnerMoves.getPreferredSize();
        this.spinnerMoves.setPreferredSize(dimension);
        this.spinnerTime = this.getSpinner(this.reqMessage.getThinkingTime(), 999);
        this.previewDrawBoard.setBoard(this.reqMessage.getBoard());
        JButtonGroup jButtonGroup = new JButtonGroup();
        jButtonGroup.add(this.radioWhite);
        jButtonGroup.add(this.radioBlack);
        boolean bl = this.reqMessage.getFollowerColor() == Side.WHITES;
        this.radioWhite.setSelected(bl);
        this.radioBlack.setSelected(!bl);
        jButtonGroup = new JButtonGroup();
        jButtonGroup.add(this.radioStartingPosition);
        jButtonGroup.add(this.radioCurrentPosition);
        jLabel.setLabelFor(this.fieldNickname);
        jLabel2.setLabelFor(this.spinnerMoves);
        jLabel5.setLabelFor(this.spinnerMoves);
        jLabel6.setLabelFor(this.spinnerTime);
        jLabel3.setLabelFor(this.radioWhite);
        jLabel4.setLabelFor(this.radioStartingPosition);
        this.spinnerMoves.setEnabled(!this.accept);
        this.spinnerTime.setEnabled(!this.accept);
        this.radioBlack.setEnabled(!this.accept);
        this.radioWhite.setEnabled(!this.accept);
        this.radioStartingPosition.setEnabled(!this.accept);
        this.radioCurrentPosition.setEnabled(!this.accept);
        ShowPreviewBoard showPreviewBoard = new ShowPreviewBoard();
        this.radioCurrentPosition.addActionListener(showPreviewBoard);
        this.radioStartingPosition.addActionListener(showPreviewBoard);
        boolean bl2 = this.startingBoard.equals(this.reqMessage.getBoard());
        this.radioStartingPosition.setSelected(bl2);
        this.radioCurrentPosition.setSelected(!bl2);
        this.radioCurrentPosition.setVisible(!this.accept);
        this.radioStartingPosition.setVisible(!this.accept);
        jPanel.add((Component)jLabel, new CustomLayoutConstraints(0, 0));
        jPanel.add((Component)this.fieldNickname, new CustomLayoutConstraints(1, 0, 2, 1));
        jPanel.add((Component)jLabel2, new CustomLayoutConstraints(0, 1));
        jPanel.add((Component)this.spinnerMoves, new CustomLayoutConstraints(1, 1));
        jPanel.add((Component)jLabel5, new CustomLayoutConstraints(2, 1, 1, 1, 3, 1));
        jPanel.add((Component)this.spinnerTime, new CustomLayoutConstraints(3, 1));
        jPanel.add((Component)jLabel6, new CustomLayoutConstraints(4, 1));
        jPanel.add((Component)jLabel3, new CustomLayoutConstraints(0, 2));
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 10, 10));
        jPanel2.setBorder(null);
        jPanel2.add(this.radioWhite);
        jPanel2.add(this.radioBlack);
        jPanel.add((Component)jPanel2, new CustomLayoutConstraints(1, 2, 4, 1));
        jPanel.add((Component)jLabel4, new CustomLayoutConstraints(0, 3));
        jPanel.add((Component)this.previewDrawBoard, new CustomLayoutConstraints(1, 3, 3, 1, 3, 1));
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 10, 10));
        jPanel3.setBorder(null);
        jPanel3.add(this.radioStartingPosition);
        jPanel3.add(this.radioCurrentPosition);
        jPanel.add((Component)jPanel3, new CustomLayoutConstraints(1, 4, 4, 1));
        JPanel jPanel4 = new JPanel(new EqualsLayout(5));
        jPanel4.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 6));
        jPanel4.setPreferredSize(new Dimension(239, 32));
        Dimension dimension2 = new Dimension(75, 25);
        this.btnCancel.setMinimumSize(dimension2);
        this.btnSave.setMinimumSize(dimension2);
        jPanel4.add(this.btnSave);
        jPanel4.add(this.btnCancel);
        this.btnSave.addActionListener(new SetAcceptAction());
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NewGameDialog.this.doClose();
            }
        });
        container.add((Component)jPanel, "Center");
        container.add((Component)jPanel4, "South");
    }

    public void doClose() {
        this.previewDrawBoard.dispose();
        super.doClose();
    }

    protected AbstractButton getCancelButton() {
        return this.btnCancel;
    }

    protected AbstractButton getOkButton() {
        return this.btnSave;
    }

    private JSpinner getSpinner(int n, int n2) {
        JSpinner jSpinner = new JSpinner(new SpinnerNumberModel(n, 0, n2, 1));
        ((JSpinner.NumberEditor)jSpinner.getEditor()).getFormat().setMinimumIntegerDigits(n2 < 100 ? 2 : 3);
        jSpinner.setValue(n);
        return jSpinner;
    }

    public GameReqMessage getReqMessage() {
        return this.reqMessage;
    }

    private class ShowPreviewBoard
    implements ActionListener {
        private ShowPreviewBoard() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (NewGameDialog.this.radioStartingPosition.isSelected()) {
                NewGameDialog.this.previewDrawBoard.setBoard(NewGameDialog.this.startingBoard);
            } else {
                NewGameDialog.this.previewDrawBoard.setBoard(NewGameDialog.this.reqMessage.getBoard());
            }
        }
    }

    private class SetAcceptAction
    implements ActionListener {
        private SetAcceptAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!NewGameDialog.this.accept) {
                if (NewGameDialog.this.fieldNickname.getText() == null || NewGameDialog.this.fieldNickname.getText().trim().length() == 0) {
                    Swinger.showErrorDialog(MainApp.getInstance().getMainAppFrame(), "Nick name is required");
                    Swinger.inputFocus(NewGameDialog.this.fieldNickname);
                    return;
                }
                NewGameDialog.this.reqMessage = new GameReqMessage(NewGameDialog.this.fieldNickname.getText(), NewGameDialog.this.radioWhite.isSelected() ? Side.BLACKS : Side.WHITES, (Integer)NewGameDialog.this.spinnerTime.getValue(), (Integer)NewGameDialog.this.spinnerMoves.getValue(), NewGameDialog.this.radioStartingPosition.isSelected() ? null : NewGameDialog.this.reqMessage.getBoard());
            }
            NewGameDialog.this.setResult(0);
            NewGameDialog.this.doClose();
        }
    }
}

