/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.dialogs.damexchange;

import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.damaq.core.Lng;
import net.damaq.core.swing.CustomLayoutConstraints;
import net.damaq.dialogs.damexchange.DamExchangeDialog;
import net.damaq.utilities.LogUtils;
import net.damaq.utilities.Swinger;

public final class WaitForResponseDialog
extends DamExchangeDialog {
    private static final Logger logger = Logger.getLogger(WaitForResponseDialog.class.getName());
    private final JButton btnCancel = Swinger.getButton("dialog.timer.btnCancel");

    public WaitForResponseDialog(Frame frame) {
        super(frame, true);
        try {
            this.init();
        }
        catch (Exception exception) {
            LogUtils.processException(logger, exception);
        }
        Swinger.centerDialog(frame, this);
        this.setModal(true);
        this.setTitle(Lng.getLabel("dialog.wait.title"));
        this.setDefaultCloseOperation(2);
    }

    protected AbstractButton getCancelButton() {
        return this.btnCancel;
    }

    private void init() {
        Container container = this.getContentPane();
        TableLayout tableLayout = new TableLayout(new double[]{-1.0, -2.0, -1.0}, new double[]{-1.0, -2.0, -2.0, -1.0});
        tableLayout.setHGap(4);
        tableLayout.setVGap(4);
        container.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(tableLayout);
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(4, 4, 4, 4))));
        JLabel jLabel = Swinger.getLabel("dialog.wait.labelWait");
        jPanel.add((Component)jLabel, new CustomLayoutConstraints(1, 1));
        jPanel.add((Component)this.btnCancel, new CustomLayoutConstraints(1, 2, 1, 1, 1, 1));
        Dimension dimension = new Dimension(75, 25);
        this.btnCancel.setMinimumSize(dimension);
        jPanel.setPreferredSize(new Dimension(150, 100));
        container.add(jPanel);
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WaitForResponseDialog.this.doClose();
            }
        });
        this.pack();
    }
}

