/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.dialogs.pdn;

import info.clearthought.layout.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import net.damaq.core.Lng;
import net.damaq.core.swing.CustomLayoutConstraints;
import net.damaq.core.swing.JButtonGroup;
import net.damaq.dialogs.AppDialog;
import net.damaq.dialogs.GameDetails;
import net.damaq.dialogs.PreviewDrawBoard;
import net.damaq.dialogs.layouts.EqualsLayout;
import net.damaq.dialogs.pdn.TableSorter;
import net.damaq.pdn.PDNGame;
import net.damaq.pdn.PDNResultSection;
import net.damaq.pdn.PDNSection;
import net.damaq.utilities.LogUtils;
import net.damaq.utilities.Swinger;
import net.damaq.utilities.SwingerUtils;
import net.damaq.utilities.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PDNGamesDialog
extends AppDialog
implements ListSelectionListener {
    private final JButton btnLoad = Swinger.getButton("dialog.pdn.btnLoad");
    private final JButton btnCancel = Swinger.getButton("dialog.pdn.btnCancel");
    private final List<PDNGame> gameList;
    private final JLabel gametypeInfoLabel = new JLabel("");
    private final JLabel resultInfoLabel = new JLabel("");
    private final JLabel openeningInfoLabel = new JLabel("");
    private final JLabel siteInfoLabel = new JLabel("");
    private final JLabel fileInfoLabel = new JLabel("");
    private final JLabel eventInfoLabel = new JLabel("");
    private final JLabel dateInfoLabel = new JLabel("");
    private final JLabel whiteInfoLabel = new JLabel("");
    private final JLabel blackInfoLabel = new JLabel("");
    private final JLabel roundInfoLabel = new JLabel("");
    private final JRadioButton radioStartingPosition = Swinger.getRadio("dialog.pdn.startingPosition");
    private final JRadioButton radioLastPosition = Swinger.getRadio("dialog.pdn.lastPosition");
    private static final int COLUMN_ID = 0;
    private static final int COLUMN_RESULT = 1;
    private static final int COLUMN_PLAYERS = 2;
    private static final int COLUMN_DATE = 3;
    private static final int COLUMN_MOVES = 4;
    private static final int COLUMN_EVENT = 5;
    private final PreviewDrawBoard drawBoard = new PreviewDrawBoard();
    private TableSorter sorter;
    private GameDetails[] gameDetails;
    private int selectedIndex;
    private GameDetails resultGameDetails = null;
    private static final Logger logger = Logger.getLogger(PDNGamesDialog.class.getName());

    public PDNGamesDialog(Frame frame, File file, List<PDNGame> list) {
        super(frame, true);
        this.fileInfoLabel.setText(Utils.shortenFileName(file.toString(), 100));
        this.gameList = list;
        this.gameDetails = new GameDetails[list.size()];
        try {
            this.init();
        }
        catch (Exception exception) {
            LogUtils.processException(logger, exception);
        }
        this.pack();
        Swinger.centerDialog(frame, this);
        this.setModal(true);
        this.setTitle(Lng.getLabel("dialog.pdn.title"));
        this.setDefaultCloseOperation(2);
        this.setVisible(true);
    }

    @Override
    protected AbstractButton getCancelButton() {
        return this.btnCancel;
    }

    @Override
    protected AbstractButton getOkButton() {
        return this.btnLoad;
    }

    private void init() {
        this.sorter = new TableSorter(this.prepareData(this.gameList));
        JTable jTable = new JTable(this.sorter);
        jTable.addMouseListener(new MouseClickAdapter());
        InputMap inputMap = jTable.getInputMap(1);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0);
        inputMap.put(keyStroke, "enter");
        jTable.getActionMap().put("enter", null);
        this.sorter.setTableHeader(jTable.getTableHeader());
        this.sorter.setSortingStatus(0, 1);
        jTable.setCellSelectionEnabled(true);
        jTable.setColumnSelectionAllowed(false);
        this.sorter.setColumnComparator(Integer.class, TableSorter.COMPARABLE_COMPARATOR);
        this.btnLoad.setEnabled(false);
        JButtonGroup jButtonGroup = new JButtonGroup();
        jButtonGroup.add(this.radioLastPosition);
        jButtonGroup.add(this.radioStartingPosition);
        this.radioLastPosition.setSelected(true);
        DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)jTable.getSelectionModel();
        defaultListSelectionModel.setSelectionMode(0);
        defaultListSelectionModel.setLeadAnchorNotificationEnabled(false);
        defaultListSelectionModel.addListSelectionListener(this);
        jTable.setSelectionModel(defaultListSelectionModel);
        this.updateInfoData(0);
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        TableColumn tableColumn = SwingerUtils.updateColumn(jTable, defaultTableCellRenderer, 0, 40);
        tableColumn.setMaxWidth(40);
        defaultTableCellRenderer.setHorizontalAlignment(4);
        defaultTableCellRenderer = new ResultCellRenderer();
        SwingerUtils.updateColumn(jTable, defaultTableCellRenderer, 1, 40);
        defaultTableCellRenderer.setHorizontalAlignment(0);
        SwingerUtils.updateColumn(jTable, 2, 150);
        defaultTableCellRenderer = new DefaultTableCellRenderer();
        SwingerUtils.updateColumn(jTable, defaultTableCellRenderer, 3, 55);
        defaultTableCellRenderer.setHorizontalAlignment(0);
        defaultTableCellRenderer = new DefaultTableCellRenderer();
        SwingerUtils.updateColumn(jTable, defaultTableCellRenderer, 4, 40);
        defaultTableCellRenderer.setHorizontalAlignment(0);
        SwingerUtils.updateColumn(jTable, 5, 200);
        jTable.changeSelection(0, 0, false, false);
        JPanel jPanel = new JPanel(new EqualsLayout(5));
        jPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 5));
        jPanel.setPreferredSize(new Dimension(239, 32));
        Dimension dimension = new Dimension(75, 25);
        this.btnCancel.setMinimumSize(dimension);
        this.btnLoad.setMinimumSize(dimension);
        jPanel.add(this.btnLoad);
        jPanel.add(this.btnCancel);
        TableLayout tableLayout = new TableLayout(new double[]{-2.0, -1.0, -2.0, 20.0}, new double[]{-2.0});
        TableLayout tableLayout2 = new TableLayout(new double[]{-2.0, -2.0, -2.0, -2.0, -1.0}, new double[]{-2.0, -2.0, -2.0, -2.0, -2.0, -2.0, -2.0, -2.0, -2.0, -2.0, -2.0, -2.0});
        tableLayout.setHGap(3);
        tableLayout.setVGap(2);
        tableLayout2.setHGap(3);
        tableLayout2.setVGap(2);
        JPanel jPanel2 = new JPanel(tableLayout);
        JPanel jPanel3 = new JPanel(tableLayout2);
        jPanel3.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        Font font = this.fileInfoLabel.getFont().deriveFont(0);
        this.fileInfoLabel.setFont(font);
        this.siteInfoLabel.setFont(font);
        this.gametypeInfoLabel.setFont(font);
        this.eventInfoLabel.setFont(font);
        this.dateInfoLabel.setFont(font);
        Dimension dimension2 = this.dateInfoLabel.getPreferredSize();
        dimension2.width = 100;
        this.dateInfoLabel.setMinimumSize(dimension2);
        this.whiteInfoLabel.setFont(font);
        this.blackInfoLabel.setFont(font);
        this.resultInfoLabel.setFont(font);
        this.roundInfoLabel.setFont(font);
        this.openeningInfoLabel.setFont(font);
        JLabel jLabel = Swinger.getLabel("dialog.pdn.fileLabel");
        Font font2 = jLabel.getFont().deriveFont(1);
        jLabel.setFont(font2);
        JLabel jLabel2 = Swinger.getLabel("dialog.pdn.siteLabel");
        jLabel2.setFont(font2);
        JLabel jLabel3 = Swinger.getLabel("dialog.pdn.dateLabel");
        jLabel3.setFont(font2);
        JLabel jLabel4 = Swinger.getLabel("dialog.pdn.eventLabel");
        jLabel4.setFont(font2);
        JLabel jLabel5 = Swinger.getLabel("dialog.pdn.gametypeLabel");
        jLabel4.setFont(font2);
        JLabel jLabel6 = Swinger.getLabel("dialog.pdn.whiteLabel");
        jLabel6.setFont(font2);
        JLabel jLabel7 = Swinger.getLabel("dialog.pdn.blackLabel");
        jLabel7.setFont(font2);
        JLabel jLabel8 = Swinger.getLabel("dialog.pdn.resultLabel");
        jLabel8.setFont(font2);
        JLabel jLabel9 = Swinger.getLabel("dialog.pdn.roundLabel");
        jLabel9.setFont(font2);
        JLabel jLabel10 = Swinger.getLabel("dialog.pdn.openingLabel");
        jLabel10.setFont(font2);
        JLabel jLabel11 = Swinger.getLabel("dialog.pdn.previewLabel");
        jLabel11.setFont(font2);
        jPanel2.setBorder(BorderFactory.createEtchedBorder());
        jPanel2.add((Component)jPanel3, new CustomLayoutConstraints(0, 0));
        jPanel2.add((Component)this.drawBoard, new CustomLayoutConstraints(2, 0, 1, 1, 3, 1));
        jPanel3.add((Component)jLabel, new CustomLayoutConstraints(0, 0));
        jPanel3.add((Component)jLabel5, new CustomLayoutConstraints(0, 2));
        jPanel3.add((Component)jLabel4, new CustomLayoutConstraints(0, 3));
        jPanel3.add((Component)jLabel2, new CustomLayoutConstraints(0, 4));
        jPanel3.add((Component)jLabel3, new CustomLayoutConstraints(0, 5));
        jPanel3.add((Component)jLabel6, new CustomLayoutConstraints(0, 6));
        jPanel3.add((Component)jLabel7, new CustomLayoutConstraints(0, 7));
        jPanel3.add((Component)jLabel8, new CustomLayoutConstraints(0, 8));
        jPanel3.add((Component)jLabel10, new CustomLayoutConstraints(0, 9));
        jPanel3.add((Component)jLabel11, new CustomLayoutConstraints(0, 11));
        jPanel3.add((Component)jLabel9, new CustomLayoutConstraints(2, 4, 1, 1, 0, 1));
        jPanel3.add((Component)this.fileInfoLabel, new CustomLayoutConstraints(1, 0, 4, 1));
        jPanel3.add((Component)new JSeparator(0), new CustomLayoutConstraints(0, 1, 5, 1));
        jPanel3.add((Component)this.gametypeInfoLabel, new CustomLayoutConstraints(1, 2, 3, 1));
        jPanel3.add((Component)this.eventInfoLabel, new CustomLayoutConstraints(1, 3, 3, 1));
        jPanel3.add((Component)this.siteInfoLabel, new CustomLayoutConstraints(1, 4, 3, 1));
        jPanel3.add((Component)this.dateInfoLabel, new CustomLayoutConstraints(1, 5));
        jPanel3.add((Component)this.whiteInfoLabel, new CustomLayoutConstraints(1, 6, 3, 1));
        jPanel3.add((Component)this.blackInfoLabel, new CustomLayoutConstraints(1, 7, 3, 1));
        jPanel3.add((Component)this.resultInfoLabel, new CustomLayoutConstraints(1, 8, 3, 1));
        jPanel3.add((Component)this.openeningInfoLabel, new CustomLayoutConstraints(1, 9, 4, 1));
        jPanel3.add((Component)this.roundInfoLabel, new CustomLayoutConstraints(3, 4, 1, 1, 4, 1));
        jPanel3.add((Component)new JSeparator(0), new CustomLayoutConstraints(0, 10, 5, 1));
        jPanel3.add((Component)this.radioStartingPosition, new CustomLayoutConstraints(1, 11));
        jPanel3.add((Component)this.radioLastPosition, new CustomLayoutConstraints(2, 11, 2, 1));
        Container container = this.getContentPane();
        TableLayout tableLayout3 = new TableLayout(new double[]{-1.0}, new double[]{-1.0, -2.0, -2.0});
        tableLayout3.setHGap(5);
        tableLayout3.setVGap(2);
        container.setLayout(tableLayout3);
        this.btnLoad.addActionListener(new OpenGame());
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PDNGamesDialog.this.doClose();
            }
        });
        PreviewBoardAction previewBoardAction = new PreviewBoardAction();
        this.radioLastPosition.addActionListener(previewBoardAction);
        this.radioStartingPosition.addActionListener(previewBoardAction);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        container.add((Component)jScrollPane, new CustomLayoutConstraints(0, 0));
        container.add((Component)jPanel2, new CustomLayoutConstraints(0, 1));
        container.add((Component)jPanel, new CustomLayoutConstraints(0, 2));
        container.setPreferredSize(new Dimension(650, 470));
    }

    private TableModel prepareData(List<PDNGame> list) {
        DefaultTableModel defaultTableModel = new DefaultTableModel(){

            @Override
            public Class<?> getColumnClass(int n) {
                if (n == 0) {
                    return Integer.class;
                }
                return super.getColumnClass(n);
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        defaultTableModel.setColumnIdentifiers(new Object[]{Lng.getLabel("dialog.pdn.columnIndex"), Lng.getLabel("dialog.pdn.columnResult"), Lng.getLabel("dialog.pdn.columnPlayers"), Lng.getLabel("dialog.pdn.columnDate"), Lng.getLabel("dialog.pdn.columnMoves"), Lng.getLabel("dialog.pdn.columnEvent")});
        int n = 0;
        for (PDNGame pDNGame : list) {
            String string = (pDNGame.getWhiteSection() == null ? "" : pDNGame.getWhiteSection().getStringValue()) + " \u2013 " + (pDNGame.getBlackSection() == null ? "" : pDNGame.getBlackSection().getStringValue());
            PDNSection pDNSection = pDNGame.getDateSection();
            String string2 = "";
            if (pDNSection != null) {
                string2 = pDNGame.getDateSection().getStringValue();
            }
            Object[] objectArray = new Object[]{++n, pDNGame.getResultSection(), string, string2, SwingerUtils.matchSpaces(3, pDNGame.getMoveList().size(), false), pDNGame.getEventSection()};
            defaultTableModel.addRow(objectArray);
        }
        return defaultTableModel;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            int n = listSelectionModel.getMinSelectionIndex();
            if (n == -1) {
                return;
            }
            int n2 = (Integer)this.sorter.getValueAt(n, 0);
            this.updateInfoData(n2 - 1);
        }
    }

    private void updateInfoData(int n) {
        PDNGame pDNGame = this.gameList.get(n);
        GameDetails gameDetails = this.gameDetails[n] == null ? PDNGamesDialog.updateGameDetails(pDNGame) : this.gameDetails[n];
        this.selectedIndex = n;
        this.eventInfoLabel.setText(pDNGame.getEventSection().getStringValue());
        this.resultInfoLabel.setText(gameDetails.getStringResult());
        if (pDNGame.getSiteSection() != null) {
            this.siteInfoLabel.setText(pDNGame.getSiteSection().getStringValue());
        }
        if (pDNGame.getWhiteSection() != null) {
            this.whiteInfoLabel.setText(pDNGame.getWhiteSection().getStringValue());
        }
        if (pDNGame.getBlackSection() != null) {
            this.blackInfoLabel.setText(pDNGame.getBlackSection().getStringValue());
        }
        if (pDNGame.getDateSection() != null) {
            this.dateInfoLabel.setText(pDNGame.getDateSection().getStringValue());
        }
        if (pDNGame.getRoundSection() != null) {
            this.roundInfoLabel.setText(pDNGame.getRoundSection().getStringValue());
        }
        this.openeningInfoLabel.setText(gameDetails.getOpening());
        if (!gameDetails.isValidHistory()) {
            this.gametypeInfoLabel.setForeground(Color.RED);
            this.gametypeInfoLabel.setText(Lng.getLabel("dialog.pdn.gametypeInfoLabel"));
            this.radioLastPosition.setEnabled(false);
            this.radioStartingPosition.setEnabled(false);
            this.drawBoard.setBoard(null);
            this.btnLoad.setEnabled(false);
        } else {
            this.gametypeInfoLabel.setForeground(Color.BLUE);
            this.gametypeInfoLabel.setText(gameDetails.getSupportedGameStyle().getReadableName());
            this.radioLastPosition.setEnabled(true);
            this.radioStartingPosition.setEnabled(true);
            this.btnLoad.setEnabled(true);
            this.updatePreview(gameDetails);
        }
    }

    private void updatePreview(GameDetails gameDetails) {
        if (!gameDetails.isValidHistory()) {
            return;
        }
        if (this.radioStartingPosition.isSelected()) {
            this.drawBoard.setBoard(gameDetails.getHistoryList().get(0).getBoard());
        } else {
            this.drawBoard.setBoard(gameDetails.getHistoryList().get(gameDetails.getHistoryList().size() - 1).getBoard());
        }
    }

    private static GameDetails updateGameDetails(PDNGame pDNGame) {
        GameDetails gameDetails = new GameDetails(pDNGame);
        gameDetails.updateData();
        return gameDetails;
    }

    @Override
    public void dispose() {
        for (int i = 0; i < this.gameDetails.length; ++i) {
            this.gameDetails[i] = null;
        }
        this.gameDetails = null;
        if (this.sorter != null) {
            this.sorter.setTableModel(null);
            this.sorter = null;
        }
        super.dispose();
    }

    private void doOpenSelected() {
        if (this.gameDetails[this.selectedIndex] != null && this.gameDetails[this.selectedIndex].isValidHistory()) {
            this.setResult(0);
            this.resultGameDetails = this.gameDetails[this.selectedIndex];
            this.doClose();
        }
    }

    public GameDetails getSelectedGameDetails() {
        return this.resultGameDetails;
    }

    private final class OpenGame
    extends AbstractAction {
        private OpenGame() {
        }

        public final void actionPerformed(ActionEvent actionEvent) {
            PDNGamesDialog.this.doOpenSelected();
        }
    }

    private final class MouseClickAdapter
    extends MouseAdapter {
        private MouseClickAdapter() {
        }

        public final void mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() >= 2) {
                PDNGamesDialog.this.doOpenSelected();
            }
        }
    }

    private final class PreviewBoardAction
    extends AbstractAction {
        private PreviewBoardAction() {
        }

        public final void actionPerformed(ActionEvent actionEvent) {
            PDNGamesDialog.this.updatePreview(PDNGamesDialog.this.gameDetails[PDNGamesDialog.this.selectedIndex]);
        }
    }

    private static final class ResultCellRenderer
    extends DefaultTableCellRenderer {
        private ResultCellRenderer() {
        }

        public final Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (object != null) {
                switch (((PDNResultSection)object).getResult()) {
                    case BLACK_WINS: {
                        this.setToolTipText(Lng.getLabel("dialog.pdn.blackwon"));
                        break;
                    }
                    case WHITE_WINS: {
                        this.setToolTipText(Lng.getLabel("dialog.pdn.whitewon"));
                        break;
                    }
                    case DRAW: {
                        this.setToolTipText(Lng.getLabel("dialog.pdn.draw"));
                        break;
                    }
                    case UNDECIDED: {
                        this.setToolTipText(Lng.getLabel("dialog.pdn.undecided"));
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
            }
            return this;
        }
    }
}

