/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.dialogs.pdn;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.MaskFormatter;
import net.damaq.core.AppPrefs;
import net.damaq.core.Lng;
import net.damaq.core.MainApp;
import net.damaq.core.swing.CustomLayoutConstraints;
import net.damaq.core.swing.JButtonGroup;
import net.damaq.core.swing.RecentsComboModel;
import net.damaq.dialogs.AppDialog;
import net.damaq.dialogs.layouts.EqualsLayout;
import net.damaq.pdn.GameStatus;
import net.damaq.pdn.PDNGame;
import net.damaq.pdn.PDNSection;
import net.damaq.utilities.LogUtils;
import net.damaq.utilities.Swinger;
import net.damaq.utilities.SwingerUtils;
import net.damaq.utilities.Utils;

public final class PDNPropertiesDialog
extends AppDialog {
    private static final Logger logger = Logger.getLogger(PDNPropertiesDialog.class.getName());
    private final PDNGame pdnGame;
    private final File file;
    private final JButton btnSave = Swinger.getButton("dialog.properties.btnSave");
    private final JButton btnCancel = Swinger.getButton("dialog.properties.btnCancel");
    private final JLabel siteInfoLabel = Swinger.getLabel("dialog.properties.siteLabel");
    private final JLabel fileInfoLabel = Swinger.getLabel("dialog.properties.fileLabel");
    private final JLabel eventInfoLabel = Swinger.getLabel("dialog.properties.eventLabel");
    private final JLabel dateInfoLabel = Swinger.getLabel("dialog.properties.dateLabel");
    private final JLabel whiteInfoLabel = Swinger.getLabel("dialog.properties.whiteLabel");
    private final JLabel blackInfoLabel = Swinger.getLabel("dialog.properties.blackLabel");
    private final JLabel roundInfoLabel = Swinger.getLabel("dialog.properties.roundLabel");
    private JComboBox comboEvent;
    private JComboBox comboSite;
    private JComboBox comboWhite;
    private JComboBox comboBlack;
    private JSpinner spinnerRound;
    private final FocusListener focusListener = new Swinger.SelectAllOnFocusListener();
    private JFormattedTextField fieldDate;
    private final JRadioButton radioDraw = Swinger.getRadio("dialog.properties.radioDraw");
    private final JRadioButton radioUndecided = Swinger.getRadio("dialog.properties.radioU");
    private final JRadioButton radioBlackWins = Swinger.getRadio("dialog.properties.radioB");
    private final JRadioButton radioWhiteWins = Swinger.getRadio("dialog.properties.radioW");
    private final String fileInfo;
    private final JCheckBox checkAppend = Swinger.getCheckBox("dialog.properties.checkAppend");

    public PDNPropertiesDialog(Frame frame, PDNGame pDNGame, File file) {
        super(frame, true);
        this.pdnGame = pDNGame;
        this.file = file;
        this.fileInfo = Utils.shortenFileName(file.getAbsolutePath(), 40);
        try {
            this.init();
            this.initValues();
        }
        catch (Exception exception) {
            LogUtils.processException(logger, exception);
        }
        this.pack();
        Swinger.centerDialog(frame, this);
        this.setModal(true);
        this.setTitle(Lng.getLabel("dialog.properties.title"));
        this.setDefaultCloseOperation(2);
        this.setVisible(true);
    }

    private void initValues() {
        this.fieldDate.setValue(PDNPropertiesDialog.getValue(this.pdnGame.getDateSection()));
        switch (this.pdnGame.getResultSection().getResult()) {
            case BLACK_WINS: {
                this.radioBlackWins.setSelected(true);
                break;
            }
            case DRAW: {
                this.radioDraw.setSelected(true);
                break;
            }
            case UNDECIDED: {
                this.radioUndecided.setSelected(true);
                break;
            }
            case WHITE_WINS: {
                this.radioWhiteWins.setSelected(true);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.btnSave.addActionListener(new SaveGame());
    }

    protected final AbstractButton getCancelButton() {
        return this.btnCancel;
    }

    protected final AbstractButton getOkButton() {
        return this.btnSave;
    }

    private void init() {
        boolean bl;
        MaskFormatter maskFormatter;
        int n;
        TableLayout tableLayout = new TableLayout(new double[]{-2.0, -2.0, -1.0}, new double[]{-2.0, -2.0, -2.0, -2.0, -2.0, -2.0, -2.0, -2.0, -2.0, -2.0});
        tableLayout.setHGap(3);
        tableLayout.setVGap(3);
        JPanel jPanel = new JPanel(tableLayout);
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), BorderFactory.createTitledBorder(Lng.getLabel("dialog.properties"))));
        this.comboBlack = this.getEditableCombo("prevBlack", PDNPropertiesDialog.getValue(this.pdnGame.getBlackSection()));
        this.comboBlack.setToolTipText(Lng.getHint("dialog.properties.blackLabel"));
        this.comboWhite = this.getEditableCombo("prevWhite", PDNPropertiesDialog.getValue(this.pdnGame.getWhiteSection()));
        this.comboWhite.setToolTipText(Lng.getHint("dialog.properties.whiteLabel"));
        this.comboEvent = this.getEditableCombo("prevEvents", PDNPropertiesDialog.getValue(this.pdnGame.getEventSection()));
        this.comboSite = this.getEditableCombo("prevSite", PDNPropertiesDialog.getValue(this.pdnGame.getSiteSection()));
        jPanel.add((Component)this.fileInfoLabel, new CustomLayoutConstraints(0, 0));
        jPanel.add((Component)new JSeparator(), new CustomLayoutConstraints(0, 1, 3, 1));
        jPanel.add((Component)this.eventInfoLabel, new CustomLayoutConstraints(0, 2));
        jPanel.add((Component)this.siteInfoLabel, new CustomLayoutConstraints(0, 3));
        jPanel.add((Component)this.whiteInfoLabel, new CustomLayoutConstraints(0, 4));
        jPanel.add((Component)this.blackInfoLabel, new CustomLayoutConstraints(0, 5));
        jPanel.add((Component)this.dateInfoLabel, new CustomLayoutConstraints(0, 6));
        jPanel.add((Component)this.roundInfoLabel, new CustomLayoutConstraints(0, 7));
        try {
            n = this.pdnGame.getRoundSection() == null ? 1 : Integer.valueOf(this.pdnGame.getRoundSection().getStringValue());
        }
        catch (NumberFormatException numberFormatException) {
            n = 1;
        }
        this.spinnerRound = new JSpinner(new SpinnerNumberModel(n, 1, 30, 1));
        this.eventInfoLabel.setLabelFor(this.comboEvent.getEditor().getEditorComponent());
        this.siteInfoLabel.setLabelFor(this.comboSite.getEditor().getEditorComponent());
        this.whiteInfoLabel.setLabelFor(this.comboWhite.getEditor().getEditorComponent());
        this.blackInfoLabel.setLabelFor(this.comboBlack.getEditor().getEditorComponent());
        this.dateInfoLabel.setLabelFor(this.fieldDate);
        this.roundInfoLabel.setLabelFor(this.spinnerRound);
        try {
            maskFormatter = new MaskFormatter("****.**.**");
        }
        catch (ParseException parseException) {
            maskFormatter = new MaskFormatter();
        }
        this.fieldDate = new JFormattedTextField(maskFormatter);
        JLabel jLabel = SwingerUtils.setPlainFont(new JLabel(this.fileInfo));
        jPanel.add((Component)jLabel, new CustomLayoutConstraints(1, 0, 2, 1));
        jPanel.add((Component)this.comboEvent, new CustomLayoutConstraints(1, 2, 2, 1));
        jPanel.add((Component)this.comboSite, new CustomLayoutConstraints(1, 3, 2, 1));
        jPanel.add((Component)this.comboWhite, new CustomLayoutConstraints(1, 4, 2, 1));
        jPanel.add((Component)this.comboBlack, new CustomLayoutConstraints(1, 5, 2, 1));
        jPanel.add((Component)this.fieldDate, new CustomLayoutConstraints(1, 6));
        jPanel.add((Component)this.spinnerRound, new CustomLayoutConstraints(1, 7));
        Swinger.addKeyActions(this.fieldDate);
        this.fieldDate.addFocusListener(this.focusListener);
        this.fieldDate.setToolTipText(Lng.getHint("dialog.properties.dateLabel"));
        TableLayout tableLayout2 = new TableLayout(new double[]{-2.0, -1.0}, new double[]{-2.0, -2.0});
        tableLayout.setHGap(3);
        tableLayout.setVGap(2);
        JButtonGroup jButtonGroup = new JButtonGroup();
        jButtonGroup.add(this.radioBlackWins);
        jButtonGroup.add(this.radioDraw);
        jButtonGroup.add(this.radioUndecided);
        jButtonGroup.add(this.radioWhiteWins);
        JPanel jPanel2 = new JPanel(tableLayout2);
        jPanel2.setBorder(BorderFactory.createTitledBorder(Lng.getLabel("dialog.properties.borderResult")));
        jPanel2.add((Component)this.radioWhiteWins, new CustomLayoutConstraints(0, 0));
        jPanel2.add((Component)this.radioBlackWins, new CustomLayoutConstraints(0, 1));
        jPanel2.add((Component)this.radioDraw, new CustomLayoutConstraints(1, 0));
        jPanel2.add((Component)this.radioUndecided, new CustomLayoutConstraints(1, 1));
        jPanel.add((Component)jPanel2, new CustomLayoutConstraints(0, 8, 3, 1));
        boolean bl2 = bl = this.file.length() > 0L;
        if (!bl) {
            this.checkAppend.setToolTipText(Lng.getLabel("dialog.properties.checkAppend.info"));
            this.checkAppend.setSelected(true);
        } else {
            this.checkAppend.setSelected(AppPrefs.getProperty("appendGameToEnd", true));
        }
        this.checkAppend.setEnabled(bl);
        jPanel.add((Component)this.checkAppend, new CustomLayoutConstraints(0, 9, 3, 1));
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PDNPropertiesDialog.this.doClose();
            }
        });
        JPanel jPanel3 = new JPanel(new EqualsLayout(5));
        jPanel3.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 5));
        jPanel3.setPreferredSize(new Dimension(239, 32));
        Dimension dimension = new Dimension(75, 25);
        this.btnCancel.setMinimumSize(dimension);
        this.btnSave.setMinimumSize(dimension);
        jPanel3.add(this.btnSave);
        jPanel3.add(this.btnCancel);
        TableLayout tableLayout3 = new TableLayout(new double[]{-1.0}, new double[]{-2.0, -2.0});
        tableLayout3.setHGap(3);
        tableLayout3.setVGap(2);
        Dimension dimension2 = this.fieldDate.getPreferredSize();
        dimension2.width = 75;
        this.fieldDate.setPreferredSize(dimension2);
        Container container = this.getContentPane();
        container.setLayout(tableLayout3);
        container.add((Component)jPanel, new CustomLayoutConstraints(0, 0));
        container.add((Component)jPanel3, new CustomLayoutConstraints(0, 1));
    }

    private JComboBox getEditableCombo(String string, String string2) {
        JComboBox jComboBox = new JComboBox(new RecentsComboModel(string, false));
        SwingerUtils.setPlainFont(jComboBox);
        SwingerUtils.addKeyActionsForCombobox(jComboBox);
        jComboBox.setEditable(true);
        jComboBox.setSelectedItem(string2);
        JTextField jTextField = (JTextField)jComboBox.getEditor().getEditorComponent();
        jTextField.addFocusListener(this.focusListener);
        jTextField.setColumns(15);
        return jComboBox;
    }

    private static String getValue(PDNSection pDNSection) {
        return pDNSection == null ? "" : pDNSection.getStringValue();
    }

    public final PDNGame getResult() {
        return this.getModalResult() == 0 ? this.pdnGame : null;
    }

    private void doSaveSelected() {
        this.setResult(0);
        GameStatus gameStatus = this.radioBlackWins.isSelected() ? GameStatus.BLACK_WINS : (this.radioWhiteWins.isSelected() ? GameStatus.BLACK_WINS : (this.radioDraw.isSelected() ? GameStatus.DRAW : GameStatus.UNDECIDED));
        this.pdnGame.setResultSection(gameStatus);
        this.pdnGame.setEventSection(this.comboEvent.getSelectedItem().toString());
        this.pdnGame.setSiteSection(this.comboSite.getSelectedItem().toString());
        this.pdnGame.setWhiteSection(this.comboWhite.getSelectedItem().toString());
        this.pdnGame.setBlackSection(this.comboBlack.getSelectedItem().toString());
        this.pdnGame.setRoundSection(this.spinnerRound.getValue().toString());
        this.pdnGame.setDateSection(this.fieldDate.getText());
        SwingerUtils.storeProperties((RecentsComboModel)this.comboBlack.getModel());
        SwingerUtils.storeProperties((RecentsComboModel)this.comboSite.getModel());
        SwingerUtils.storeProperties((RecentsComboModel)this.comboWhite.getModel());
        SwingerUtils.storeProperties((RecentsComboModel)this.comboEvent.getModel());
        if (this.checkAppend.isEnabled()) {
            AppPrefs.storeProperty("appendGameToEnd", this.checkAppend.isSelected());
        }
        this.doClose();
    }

    private final class SaveGame
    extends AbstractAction {
        private SaveGame() {
        }

        public final void actionPerformed(ActionEvent actionEvent) {
            String string = PDNPropertiesDialog.this.fieldDate.getText();
            if (string.indexOf(63) == -1) {
                try {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy.MM.dd");
                    simpleDateFormat.setLenient(false);
                    simpleDateFormat.parse(string);
                }
                catch (ParseException parseException) {
                    Swinger.showErrorDialog(MainApp.getInstance().getMainAppFrame(), Lng.getLabel("message.error.invalidDate"));
                    Swinger.inputFocus(PDNPropertiesDialog.this.fieldDate);
                    return;
                }
            }
            PDNPropertiesDialog.this.doSaveSelected();
        }
    }
}

