/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.dialogs.settings;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import net.damaq.core.Lng;
import net.damaq.core.MainApp;
import net.damaq.core.swing.CustomLayoutConstraints;
import net.damaq.dialogs.settings.CheckBoxOption;
import net.damaq.dialogs.settings.ComboBoxOption;
import net.damaq.dialogs.settings.DefaultOptionsGroup;
import net.damaq.dialogs.settings.ListBoxOption;
import net.damaq.dialogs.settings.SettingsDialog;
import net.damaq.dialogs.settings.SettingsPanel;
import net.damaq.gui.LaF;
import net.damaq.gui.LookAndFeels;
import net.damaq.gui.SkinInfo;
import net.damaq.utilities.LogUtils;
import net.damaq.utilities.Swinger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AppearanceSettingsPanel
extends SettingsPanel {
    private static final Logger logger = Logger.getLogger(AppearanceSettingsPanel.class.getName());
    private JLabel labelAuthorInfo;

    public AppearanceSettingsPanel(SettingsDialog settingsDialog, String string) {
        super(settingsDialog, string);
    }

    @Override
    protected final void init() {
        JLabel jLabel = Swinger.getLabel("settings.lookandfeel");
        JLabel jLabel2 = Swinger.getLabel("settings.author");
        JLabel jLabel3 = Swinger.getLabel("settings.skin");
        final LookAndFeels lookAndFeels = LookAndFeels.getInstance();
        final Vector<LaF> vector = lookAndFeels.getAvailableLookAndFeels();
        DefaultComboBoxModel<LaF> defaultComboBoxModel = new DefaultComboBoxModel<LaF>(vector);
        LaF laF = this.getSelectedLaF(vector, lookAndFeels.getSelectedLaF());
        if (laF != null) {
            defaultComboBoxModel.setSelectedItem(laF);
        }
        DefaultOptionsGroup defaultOptionsGroup = new DefaultOptionsGroup();
        ComboBoxOption comboBoxOption = new ComboBoxOption(this.manager, defaultComboBoxModel, defaultOptionsGroup){

            public void applyChange() {
                int n;
                super.applyChange();
                boolean bl = AppearanceSettingsPanel.changeLookAndFeel((LaF)this.getCombo().getSelectedItem());
                if (!bl && (n = vector.indexOf(lookAndFeels.getSelectedLaF())) != -1) {
                    this.getCombo().setSelectedItem(vector.elementAt(n));
                }
            }
        };
        JComboBox jComboBox = comboBoxOption.getCombo();
        Dimension dimension = jComboBox.getPreferredSize();
        dimension.height = 23;
        jComboBox.setPreferredSize(dimension);
        jComboBox.setMaximumSize(new Dimension(120, 23));
        jLabel.setLabelFor(comboBoxOption.getComponent());
        CheckBoxOption checkBoxOption = new CheckBoxOption(this.manager, "settings.visibleToolbars", "visibleToolbars", true, defaultOptionsGroup){

            public void applyChange() {
                super.applyChange();
                MainApp.getInstance().getMainAppFrame().getManagerDirector().getDesktopManager().updateToolbars(this.getCheckBox().isSelected());
            }
        };
        this.labelAuthorInfo = new JLabel();
        DefaultListModel<SkinInfo> defaultListModel = new DefaultListModel<SkinInfo>();
        SkinInfo skinInfo = lookAndFeels.getActiveSkin().getInfo();
        this.updateAuthorInfo(skinInfo.getSkinAuthor());
        for (SkinInfo object2 : lookAndFeels.getAvailableSkins()) {
            defaultListModel.addElement(object2);
        }
        ListBoxOption listBoxOption = new ListBoxOption(this.manager, defaultListModel, skinInfo, defaultOptionsGroup){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    AppearanceSettingsPanel.this.updateAuthorInfo(((SkinInfo)this.getList().getSelectedValue()).getSkinAuthor());
                }
                super.valueChanged(listSelectionEvent);
            }

            public void applyChange() {
                super.applyChange();
                LookAndFeels.getInstance().setSkin((SkinInfo)this.getList().getSelectedValue());
            }
        };
        listBoxOption.getComponent().setPreferredSize(new Dimension(120, 90));
        jLabel3.setLabelFor(listBoxOption.getComponent());
        CheckBoxOption checkBoxOption2 = new CheckBoxOption(this.manager, "settings.decoratedFrames", "decorated", false, defaultOptionsGroup);
        TableLayout tableLayout = new TableLayout(new double[]{-2.0, -2.0, -1.0}, new double[]{-2.0, -2.0, -2.0, -2.0, -2.0});
        tableLayout.setHGap(10);
        tableLayout.setVGap(3);
        this.setLayout(tableLayout);
        this.add((Component)jLabel, new CustomLayoutConstraints(0, 0));
        this.add((Component)comboBoxOption.getComponent(), new CustomLayoutConstraints(1, 0, 2, 1, 0, 0));
        this.add((Component)jLabel3, new CustomLayoutConstraints(0, 1));
        this.add((Component)new JScrollPane(listBoxOption.getComponent()), new CustomLayoutConstraints(1, 1, 2, 1, 0, 0));
        this.add((Component)jLabel2, new CustomLayoutConstraints(1, 2));
        this.add((Component)this.labelAuthorInfo, new CustomLayoutConstraints(2, 2, 1, 1, 0, 0));
        this.add((Component)checkBoxOption.getComponent(), new CustomLayoutConstraints(0, 3, 3, 1));
        this.add((Component)checkBoxOption2.getComponent(), new CustomLayoutConstraints(0, 4, 3, 1));
    }

    private LaF getSelectedLaF(Vector<LaF> vector, LaF laF) {
        if (laF.getClassName().equals("org.jvnet.substance.SubstanceLookAndFeel")) {
            for (LaF laF2 : vector) {
                if (!laF2.getClassName().equals("org.jvnet.substance.SubstanceLookAndFeel")) continue;
                return laF2;
            }
        } else {
            int n = vector.indexOf(laF);
            if (n != -1) {
                return vector.get(n);
            }
            return vector.get(0);
        }
        return vector.get(0);
    }

    private static boolean changeLookAndFeel(LaF laF) {
        if (LookAndFeels.getInstance().getSelectedLaF().equals((Object)laF)) {
            return true;
        }
        boolean bl = false;
        try {
            bl = LookAndFeels.getInstance().loadLookAndFeel(laF, true);
            if (bl) {
                LookAndFeels.getInstance().storeSelectedLaF(laF);
            }
        }
        catch (Exception exception) {
            LogUtils.processException(logger, exception);
        }
        if (bl) {
            try {
                Swinger.showInformationDialog(MainApp.getInstance().getMainAppFrame(), Lng.getLabel("ChangeLookAndFeelAction.set"));
            }
            catch (Exception exception) {
                LogUtils.processException(logger, exception);
            }
        } else {
            Swinger.showErrorDialog(MainApp.getInstance().getMainAppFrame(), Lng.getLabel("ChangeLookAndFeelAction.failed"));
        }
        return bl;
    }

    private void updateAuthorInfo(String string) {
        this.labelAuthorInfo.setText(string);
    }
}

