/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.dialogs.settings;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import net.damaq.core.AppPrefs;
import net.damaq.dialogs.settings.IOptionGroup;
import net.damaq.dialogs.settings.IOptionable;
import net.damaq.dialogs.settings.OptionsGroupManager;
import net.damaq.utilities.Swinger;

class CheckBoxOption
implements IOptionable,
ItemListener {
    private final boolean initValue;
    private boolean applyedValue;
    private final boolean defaultValue = false;
    private boolean wasChanged = false;
    private final OptionsGroupManager optionsGroupManager;
    private IOptionGroup group = null;
    private String propertyName = null;
    private final JCheckBox check;

    public CheckBoxOption(OptionsGroupManager optionsGroupManager, String string, String string2, boolean bl, IOptionGroup iOptionGroup) {
        this(optionsGroupManager, string, AppPrefs.getProperty(string2, bl), iOptionGroup);
        this.propertyName = string2;
    }

    public CheckBoxOption(OptionsGroupManager optionsGroupManager, String string, boolean bl, IOptionGroup iOptionGroup) {
        this.check = Swinger.getCheckBox(string);
        this.initValue = this.applyedValue = bl;
        this.group = iOptionGroup;
        this.check.setSelected(bl);
        this.optionsGroupManager = optionsGroupManager;
        this.check.addItemListener(this);
    }

    private void updateValue() {
        this.wasChanged = this.applyedValue != this.check.isSelected();
        this.optionsGroupManager.makeChange(this);
    }

    public final void itemStateChanged(ItemEvent itemEvent) {
        this.updateValue();
    }

    public final void setDefault() {
        this.check.setSelected(this.defaultValue);
    }

    public final void restorePrevious() {
        this.check.setSelected(this.initValue);
    }

    public final boolean wasChanged() {
        return this.wasChanged;
    }

    public void applyChange() {
        this.wasChanged = false;
        this.applyedValue = this.check.isSelected();
        if (this.propertyName != null) {
            AppPrefs.storeProperty(this.propertyName, this.applyedValue);
        }
    }

    public final IOptionGroup getOptionsGroup() {
        return this.group;
    }

    public JComponent getComponent() {
        return this.check;
    }

    public JCheckBox getCheckBox() {
        return this.check;
    }
}

