/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.dialogs.settings;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import net.damaq.dialogs.settings.IOptionGroup;
import net.damaq.dialogs.settings.IOptionable;
import net.damaq.dialogs.settings.OptionsGroupManager;

class ComboBoxOption
implements IOptionable,
ItemListener {
    private final Object initValue;
    private Object applyedValue;
    private final Object defaultValue = null;
    private boolean wasChanged = false;
    private final OptionsGroupManager optionsGroupManager;
    private IOptionGroup group = null;
    private final JComboBox combo;

    public ComboBoxOption(OptionsGroupManager optionsGroupManager, ComboBoxModel comboBoxModel, IOptionGroup iOptionGroup) {
        this.combo = new JComboBox(comboBoxModel);
        this.initValue = this.applyedValue = this.combo.getSelectedItem();
        this.group = iOptionGroup;
        this.combo.setSelectedItem(comboBoxModel.getSelectedItem());
        this.optionsGroupManager = optionsGroupManager;
        this.combo.addItemListener(this);
    }

    private void updateValue() {
        this.wasChanged = !this.applyedValue.equals(this.combo.getSelectedItem());
        this.optionsGroupManager.makeChange(this);
    }

    public final void itemStateChanged(ItemEvent itemEvent) {
        this.updateValue();
    }

    public final void setDefault() {
        if (this.defaultValue != null) {
            this.combo.setSelectedItem(this.defaultValue);
        }
    }

    public final void restorePrevious() {
        this.combo.setSelectedItem(this.initValue);
    }

    public final boolean wasChanged() {
        return this.wasChanged;
    }

    public void applyChange() {
        this.wasChanged = false;
        this.applyedValue = this.combo.getSelectedItem();
    }

    public final IOptionGroup getOptionsGroup() {
        return this.group;
    }

    public JComponent getComponent() {
        return this.combo;
    }

    public JComboBox getCombo() {
        return this.combo;
    }
}

