/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.dialogs.settings;

import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import net.damaq.core.AppPrefs;
import net.damaq.dialogs.settings.IOptionGroup;
import net.damaq.dialogs.settings.IOptionable;
import net.damaq.dialogs.settings.OptionsGroupManager;
import net.damaq.utilities.Swinger;

class JTextFieldOption
implements IOptionable,
DocumentListener {
    private final String initValue;
    private String defaultValue;
    private boolean wasChanged = false;
    private final OptionsGroupManager optionsGroupManager;
    private IOptionGroup group = null;
    private String propertyName = null;
    private final JTextField field;

    public JTextFieldOption(OptionsGroupManager optionsGroupManager, Document document, String string, String string2, IOptionGroup iOptionGroup) {
        this(optionsGroupManager, document, AppPrefs.getProperty(string, string2), iOptionGroup);
        this.propertyName = string;
        this.defaultValue = string2;
    }

    private JTextFieldOption(OptionsGroupManager optionsGroupManager, Document document, String string, IOptionGroup iOptionGroup) {
        if (document == null) {
            document = new PlainDocument();
        }
        this.field = new JTextField(document, string, 0);
        this.initValue = string;
        this.group = iOptionGroup;
        this.optionsGroupManager = optionsGroupManager;
        document.addDocumentListener(this);
        Swinger.addKeyActions(this.field);
    }

    private void updateValue() {
        this.wasChanged = !this.initValue.equals(this.field.getText());
        this.optionsGroupManager.makeChange(this);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateValue();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateValue();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateValue();
    }

    public final void setDefault() {
        this.field.setText(this.defaultValue);
    }

    public final void restorePrevious() {
        this.field.setText(this.initValue);
    }

    public final boolean wasChanged() {
        return this.wasChanged;
    }

    public void applyChange() {
        this.wasChanged = false;
        if (this.propertyName != null) {
            AppPrefs.storeProperty(this.propertyName, this.field.getText());
        }
    }

    public final IOptionGroup getOptionsGroup() {
        return this.group;
    }

    public JComponent getComponent() {
        return this.field;
    }
}

