/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.dialogs.settings;

import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.damaq.dialogs.settings.IOptionGroup;
import net.damaq.dialogs.settings.IOptionable;
import net.damaq.dialogs.settings.OptionsGroupManager;

class ListBoxOption
implements IOptionable,
ListSelectionListener {
    private final Object initValue;
    private Object applyedValue;
    private final Object defaultValue = null;
    private boolean wasChanged = false;
    private final OptionsGroupManager optionsGroupManager;
    private IOptionGroup group = null;
    private final JList list;

    public ListBoxOption(OptionsGroupManager optionsGroupManager, ListModel listModel, Object object, IOptionGroup iOptionGroup) {
        this.list = new JList(listModel);
        this.initValue = this.applyedValue = object;
        this.group = iOptionGroup;
        this.list.setSelectedValue(object, true);
        this.optionsGroupManager = optionsGroupManager;
        this.list.addListSelectionListener(this);
    }

    private void updateValue() {
        this.wasChanged = !this.applyedValue.equals(this.list.getSelectedValue());
        this.optionsGroupManager.makeChange(this);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            this.updateValue();
        }
    }

    public final void setDefault() {
        if (this.defaultValue != null) {
            this.list.setSelectedValue(this.defaultValue, true);
        }
    }

    public final void restorePrevious() {
        this.list.setSelectedValue(this.initValue, true);
    }

    public final boolean wasChanged() {
        return this.wasChanged;
    }

    public void applyChange() {
        this.wasChanged = false;
        this.applyedValue = this.list.getSelectedValue();
    }

    public final IOptionGroup getOptionsGroup() {
        return this.group;
    }

    public JComponent getComponent() {
        return this.list;
    }

    public JList getList() {
        return this.list;
    }
}

