/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.dialogs.settings;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.nio.charset.Charset;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import net.damaq.core.AppPrefs;
import net.damaq.core.Lng;
import net.damaq.core.swing.CustomLayoutConstraints;
import net.damaq.dialogs.settings.CheckBoxOption;
import net.damaq.dialogs.settings.ComboBoxOption;
import net.damaq.dialogs.settings.DefaultOptionsGroup;
import net.damaq.dialogs.settings.SettingsDialog;
import net.damaq.dialogs.settings.SettingsPanel;
import net.damaq.utilities.Swinger;

final class MiscSettingsPanel
extends SettingsPanel {
    public MiscSettingsPanel(SettingsDialog settingsDialog, String string) {
        super(settingsDialog, string);
    }

    protected final void init() {
        DefaultOptionsGroup defaultOptionsGroup = new DefaultOptionsGroup();
        CheckBoxOption checkBoxOption = new CheckBoxOption(this.manager, "settings.playSound", "playSound", true, defaultOptionsGroup);
        CheckBoxOption checkBoxOption2 = new CheckBoxOption(this.manager, "settings.openSimplePDNFast", "openSimplePDNFast", true, defaultOptionsGroup);
        TableLayout tableLayout = new TableLayout(new double[]{-2.0, -2.0, -1.0}, new double[]{-2.0, -2.0, -2.0, -2.0});
        tableLayout.setVGap(2);
        tableLayout.setHGap(6);
        this.setLayout(tableLayout);
        Charset charset = Charset.defaultCharset();
        String string = AppPrefs.getProperty("pdnCharset", charset.name());
        final DefaultComboBoxModel<CharsetDesc> defaultComboBoxModel = new DefaultComboBoxModel<CharsetDesc>();
        for (Charset object2 : Charset.availableCharsets().values()) {
            CharsetDesc charsetDesc = new CharsetDesc(object2, charset.equals(object2));
            defaultComboBoxModel.addElement(charsetDesc);
            if (!object2.name().equals(string)) continue;
            defaultComboBoxModel.setSelectedItem(charsetDesc);
        }
        JLabel jLabel = Swinger.getLabel("settings.pdncharset");
        ComboBoxOption comboBoxOption = new ComboBoxOption(this.manager, defaultComboBoxModel, defaultOptionsGroup){

            public void applyChange() {
                super.applyChange();
                AppPrefs.storeProperty("pdnCharset", ((CharsetDesc)defaultComboBoxModel.getSelectedItem()).getCharset().name());
            }
        };
        this.add((Component)checkBoxOption2.getComponent(), new CustomLayoutConstraints(0, 0, 3, 1));
        this.add((Component)checkBoxOption.getComponent(), new CustomLayoutConstraints(0, 2, 3, 1));
        this.add((Component)jLabel, new CustomLayoutConstraints(0, 1));
        this.add((Component)comboBoxOption.getComponent(), new CustomLayoutConstraints(1, 1, 1, 1, 0, 1));
    }

    private static class CharsetDesc {
        private final Charset charset;
        private String stringValue;

        public CharsetDesc(Charset charset, boolean bl) {
            this.charset = charset;
            this.stringValue = charset.displayName() + (bl ? Lng.getLabel("settings.charsetSystemDefault") : "");
        }

        public String toString() {
            return this.stringValue;
        }

        public Charset getCharset() {
            return this.charset;
        }
    }
}

