/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.dialogs.settings;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.SwingUtilities;
import net.damaq.dialogs.settings.IOptionGroup;
import net.damaq.dialogs.settings.IOptionable;
import net.damaq.dialogs.settings.IOptionsManager;
import net.damaq.dialogs.settings.SettingsDialog;
import net.damaq.utilities.Swinger;

final class OptionsGroupManager
implements IOptionsManager {
    private final Set<IOptionable> changedComponents = new LinkedHashSet<IOptionable>(2);
    private final List<IOptionable> applyedComponents = new ArrayList<IOptionable>(2);
    private final SettingsDialog dialog;

    public OptionsGroupManager(SettingsDialog settingsDialog) {
        this.dialog = settingsDialog;
    }

    public final void makeChange(IOptionable iOptionable) {
        if (iOptionable.wasChanged()) {
            this.changedComponents.add(iOptionable);
            this.setEnableApplyButton(true);
        } else {
            this.changedComponents.remove(iOptionable);
            if (!this.wasChanged()) {
                this.setEnableApplyButton(false);
            }
        }
    }

    public final void applyChanges() {
        if (this.wasChanged()) {
            LinkedHashSet<IOptionGroup> linkedHashSet = new LinkedHashSet<IOptionGroup>(2);
            Iterator<IOptionable> iterator = this.changedComponents.iterator();
            while (iterator.hasNext()) {
                IOptionable object;
                IOptionable iOptionable = object = iterator.next();
                linkedHashSet.add(iOptionable.getOptionsGroup());
                iOptionable.applyChange();
            }
            for (IOptionGroup iOptionGroup : linkedHashSet) {
                iOptionGroup.doGroupChange();
            }
            this.applyedComponents.addAll(this.changedComponents);
            this.changedComponents.clear();
            this.setEnableApplyButton(false);
            Swinger.inputFocus(this.dialog.getButtonPanel().getOkButton());
        }
    }

    public final void restoreChanged() {
        IOptionable iOptionable;
        Object linkedHashSet = this.changedComponents.iterator();
        while (linkedHashSet.hasNext()) {
            IOptionable iterator2;
            iOptionable = iterator2 = linkedHashSet.next();
            iOptionable.restorePrevious();
        }
        linkedHashSet = new LinkedHashSet(2);
        Iterator<IOptionable> iterator = this.applyedComponents.iterator();
        while (iterator.hasNext()) {
            IOptionable iOptionable2;
            iOptionable = iOptionable2 = iterator.next();
            iOptionable.restorePrevious();
            linkedHashSet.add(iOptionable.getOptionsGroup());
            iOptionable.applyChange();
        }
        Iterator iterator2 = linkedHashSet.iterator();
        while (iterator2.hasNext()) {
            IOptionGroup iOptionGroup = (IOptionGroup)iterator2.next();
            iOptionGroup.doGroupChange();
        }
        this.applyedComponents.clear();
    }

    public final void resetChanges() {
        this.applyedComponents.clear();
        this.changedComponents.clear();
        this.setEnableApplyButton(false);
    }

    public final boolean wasChanged() {
        return !this.changedComponents.isEmpty();
    }

    private void setEnableButton(final AbstractButton abstractButton, final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                abstractButton.setEnabled(bl);
            }
        });
    }

    private void setEnableApplyButton(boolean bl) {
        this.setEnableButton(this.dialog.getButtonPanel().getApplyButton(), bl);
    }
}

