/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.dialogs.settings;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import net.damaq.core.Lng;
import net.damaq.dialogs.AppDialog;
import net.damaq.dialogs.settings.AppearanceSettingsPanel;
import net.damaq.dialogs.settings.ButtonPanel;
import net.damaq.dialogs.settings.ExportSettingsPanel;
import net.damaq.dialogs.settings.GeneralSettingsPanel;
import net.damaq.dialogs.settings.IOptionsManager;
import net.damaq.dialogs.settings.MiscSettingsPanel;
import net.damaq.dialogs.settings.SelectablePanel;
import net.damaq.dialogs.settings.SettingsPanel;
import net.damaq.utilities.LogUtils;
import net.damaq.utilities.Swinger;

public final class SettingsDialog
extends AppDialog {
    private static final Logger logger = Logger.getLogger(SettingsDialog.class.getName());
    private static final Dimension buttonDimension = new Dimension(140, 40);
    private ButtonPanel buttonPanel = null;
    private SelectablePanel selectablePanel;
    private static final int PANEL_GENERAL = 1;
    private static final int PANEL_EXPORT = 2;
    private static final int PANEL_MISC = 3;
    private static final int PANEL_APPEARANCE = 4;
    private JPanel panelGeneralSettings = null;
    private JPanel panelExportSettings = null;
    private JPanel panelMiscSettings = null;
    private JPanel panelAppearanceSettings = null;

    public SettingsDialog(Frame frame) {
        super(frame, true);
        try {
            this.init();
        }
        catch (Exception exception) {
            LogUtils.processException(logger, exception);
        }
        this.pack();
        Swinger.centerDialog(frame, this);
        this.setModal(true);
        this.setTitle(Lng.getLabel("settings.title"));
        this.setDefaultCloseOperation(2);
        this.setVisible(true);
    }

    private static AbstractButton getButton(Action action) {
        JToggleButton jToggleButton = new JToggleButton(action);
        jToggleButton.setHorizontalAlignment(2);
        jToggleButton.setMinimumSize(buttonDimension);
        jToggleButton.setPreferredSize(buttonDimension);
        jToggleButton.setRolloverEnabled(true);
        jToggleButton.setSize(buttonDimension);
        jToggleButton.setFocusable(true);
        return jToggleButton;
    }

    protected final AbstractButton getCancelButton() {
        return this.getButtonPanel().getCancelButton();
    }

    protected final AbstractButton getOkButton() {
        return this.getButtonPanel().getOkButton();
    }

    private JToolBar getToolBar() {
        JToolBar jToolBar = new JToolBar(1);
        jToolBar.setLayout(new GridBagLayout());
        jToolBar.setPreferredSize(new Dimension(150, 260));
        jToolBar.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createLineBorder(Color.BLACK, 1)), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        jToolBar.setFloatable(false);
        ButtonGroup buttonGroup = new ButtonGroup();
        AbstractButton abstractButton = SettingsDialog.getButton(new SelectSettingsClickAction(1, "settings.btn.general", null));
        buttonGroup.add(abstractButton);
        AbstractButton abstractButton2 = SettingsDialog.getButton(new SelectSettingsClickAction(2, "settings.btn.export", null));
        buttonGroup.add(abstractButton2);
        AbstractButton abstractButton3 = SettingsDialog.getButton(new SelectSettingsClickAction(3, "settings.btn.misc", null));
        buttonGroup.add(abstractButton3);
        AbstractButton abstractButton4 = SettingsDialog.getButton(new SelectSettingsClickAction(4, "settings.btn.appearance", null));
        buttonGroup.add(abstractButton4);
        abstractButton.setIcon(Swinger.getIcon("general.gif"));
        abstractButton2.setIcon(Swinger.getIcon("editor.gif"));
        abstractButton3.setIcon(Swinger.getIcon("miscellanous.gif"));
        abstractButton4.setIcon(Swinger.getIcon("look-feel.gif"));
        abstractButton.setSelected(true);
        jToolBar.add((Component)abstractButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        jToolBar.add((Component)abstractButton4, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 2, new Insets(4, 0, 0, 0), 0, 0));
        jToolBar.add((Component)abstractButton2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 11, 2, new Insets(4, 0, 0, 0), 0, 0));
        jToolBar.add((Component)abstractButton3, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 11, 2, new Insets(4, 0, 0, 0), 0, 0));
        jToolBar.add(Box.createVerticalStrut(4), new GridBagConstraints(0, 3, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 150, 0), 0, 0));
        return jToolBar;
    }

    public final ButtonPanel getButtonPanel() {
        return this.buttonPanel == null ? (this.buttonPanel = new ButtonPanel(this)) : this.buttonPanel;
    }

    private JPanel getAppearanceSettingsPanel() {
        return this.panelAppearanceSettings == null ? (this.panelAppearanceSettings = new AppearanceSettingsPanel(this, Lng.getLabel("settings.appearance.title"))) : this.panelAppearanceSettings;
    }

    private JPanel getGeneralSettingsPanel() {
        return this.panelGeneralSettings == null ? (this.panelGeneralSettings = new GeneralSettingsPanel(this, Lng.getLabel("settings.general.title"))) : this.panelGeneralSettings;
    }

    private JPanel getExportSettingsPanel() {
        return this.panelExportSettings == null ? (this.panelExportSettings = new ExportSettingsPanel(this, Lng.getLabel("settings.export.title"))) : this.panelExportSettings;
    }

    private JPanel getMiscSettingsPanel() {
        return this.panelMiscSettings == null ? (this.panelMiscSettings = new MiscSettingsPanel(this, Lng.getLabel("settings.misc.title"))) : this.panelMiscSettings;
    }

    private void init() {
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.getToolBar(), "West");
        JPanel jPanel = new JPanel(new BorderLayout());
        this.selectablePanel = new SelectablePanel();
        jPanel.add((Component)this.selectablePanel, "Center");
        jPanel.add((Component)this.getButtonPanel(), "South");
        container.add((Component)jPanel, "Center");
        this.selectablePanel.showCard(this.getGeneralSettingsPanel());
    }

    public final SettingsPanel getActiveSettingsPanel() {
        return (SettingsPanel)this.selectablePanel.getActiveCard();
    }

    private void updateSize() {
        this.pack();
    }

    protected final void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.getButtonPanel().getCancelButton().getAction().actionPerformed(null);
        }
    }

    private final class SelectSettingsClickAction
    extends AbstractAction {
        private final int actionCode;

        public SelectSettingsClickAction(int n, String string, String string2) {
            super(string);
            this.actionCode = n;
            this.putValue("Name", Lng.getLabel(string));
            this.putValue("MnemonicKey", new Integer(Lng.getMnemonic(string)));
            if (string2 != null) {
                this.putValue("SmallIcon", Swinger.getIcon(string2));
            }
        }

        public final void actionPerformed(ActionEvent actionEvent) {
            IOptionsManager iOptionsManager = SettingsDialog.this.getActiveSettingsPanel().getOptionsManager();
            JFrame jFrame = (JFrame)SettingsDialog.this.getParent();
            if (iOptionsManager.wasChanged()) {
                int n = Swinger.getChoice(jFrame, Lng.getLabel("settings.confirm"));
                if (n == 0) {
                    iOptionsManager.applyChanges();
                } else {
                    iOptionsManager.restoreChanged();
                }
            }
            switch (this.actionCode) {
                case 1: {
                    SettingsDialog.this.selectablePanel.showCard(SettingsDialog.this.getGeneralSettingsPanel());
                    break;
                }
                case 4: {
                    SettingsDialog.this.selectablePanel.showCard(SettingsDialog.this.getAppearanceSettingsPanel());
                    break;
                }
                case 2: {
                    SettingsDialog.this.selectablePanel.showCard(SettingsDialog.this.getExportSettingsPanel());
                    break;
                }
                case 3: {
                    SettingsDialog.this.selectablePanel.showCard(SettingsDialog.this.getMiscSettingsPanel());
                    break;
                }
                default: {
                    return;
                }
            }
            SettingsDialog.this.getActiveSettingsPanel().getOptionsManager().resetChanges();
            SettingsDialog.this.getActiveSettingsPanel().focusFirstComponent();
            SettingsDialog.this.updateSize();
        }
    }
}

