/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.dialogs.settings;

import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.damaq.dialogs.settings.IOptionGroup;
import net.damaq.dialogs.settings.IOptionable;
import net.damaq.dialogs.settings.OptionsGroupManager;

class SpinnerOption
implements IOptionable,
ChangeListener {
    private final Object initValue;
    private Object applyedValue;
    private Object defaultValue = 10;
    private boolean wasChanged = false;
    private final OptionsGroupManager optionsGroupManager;
    private IOptionGroup group = null;
    private final JSpinner spinner;

    public SpinnerOption(OptionsGroupManager optionsGroupManager, SpinnerModel spinnerModel, IOptionGroup iOptionGroup) {
        this.spinner = new JSpinner(spinnerModel);
        this.initValue = this.applyedValue = this.spinner.getValue();
        this.group = iOptionGroup;
        this.spinner.setValue(this.initValue);
        this.optionsGroupManager = optionsGroupManager;
        this.spinner.addChangeListener(this);
    }

    private void updateValue() {
        this.wasChanged = !this.applyedValue.equals(this.spinner.getValue());
        this.optionsGroupManager.makeChange(this);
    }

    public final void stateChanged(ChangeEvent changeEvent) {
        this.updateValue();
    }

    public final void setDefaultValue(Object object) {
        this.defaultValue = object;
    }

    public final void setDefault() {
        this.spinner.setValue(this.defaultValue);
    }

    public final void restorePrevious() {
        this.spinner.setValue(this.initValue);
    }

    public final boolean wasChanged() {
        return this.wasChanged;
    }

    public void applyChange() {
        this.wasChanged = false;
        this.applyedValue = this.spinner.getValue();
    }

    public JComponent getComponent() {
        return this.spinner;
    }

    public JSpinner getSpinner() {
        return this.spinner;
    }

    public final IOptionGroup getOptionsGroup() {
        return this.group;
    }
}

