/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.export;

import java.util.List;
import net.damaq.core.AppPrefs;
import net.damaq.core.managers.Game;
import net.damaq.core.managers.HistoryItem;
import net.damaq.core.managers.HistoryManager;
import net.damaq.export.Exporter;
import net.damaq.gamestyle.Side;
import net.damaq.gamestyle.interfaces.Board;
import net.damaq.gamestyle.interfaces.GameStyle;
import net.damaq.gamestyle.interfaces.Move;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppletExporter
implements Exporter {
    private Game game;
    private static final String output = "<html>%n\t<head>%n\t\t<title>%s</title>%n\t\t<!-- Applet generated by Damaq, applet by http://www.damweb.nl/ -->%n\t</head>%n\t<body>%n\t\t<applet codebase = \"http://www.damweb.nl/\" code = \"webdam.Viewer.class\" name = \"webdam\" archive =\"webdam/Viewer.jar\" width = \"360\" height = \"240\" hspace = \"0\" vspace = \"0\" align = \"middle\">%n\t\t\t<param name=\"options\" value=\"bgcolor: b0c0a0; notation:right\" />%n\t\t\t<param name=\"position\" value=\"%s\" />%n <param name=\"notation\" value=\"%s\" />%n\t\t</applet>%n\t</body>%n</html>";
    private String processedData;

    public AppletExporter(Game game) {
        this.game = game;
    }

    @Override
    public void init() {
        HistoryManager historyManager = this.game.getHistoryManager();
        Board board = historyManager.getFirstBoard();
        GameStyle gameStyle = this.game.getManager().getCurrentGameStyle();
        List<Integer>[] listArray = gameStyle.getDetailedPositions(board);
        StringBuilder stringBuilder = new StringBuilder();
        if (board.isSideToMove(Side.WHITES)) {
            stringBuilder.append("WM");
        } else {
            stringBuilder.append("BM");
        }
        this.processPositions(stringBuilder, "WP", listArray[0]);
        this.processPositions(stringBuilder, "WK", listArray[1]);
        this.processPositions(stringBuilder, "BP", listArray[2]);
        this.processPositions(stringBuilder, "BK", listArray[3]);
        StringBuilder stringBuilder2 = new StringBuilder();
        List<HistoryItem> list = historyManager.getMoveList();
        for (HistoryItem historyItem : list) {
            if (!historyItem.isMove()) continue;
            this.processMove(stringBuilder2, historyItem.getMove());
        }
        this.processedData = String.format(output, gameStyle.getReadableName(), stringBuilder.toString(), stringBuilder2.toString());
    }

    private void processPositions(StringBuilder stringBuilder, String string, List<Integer> list) {
        if (!list.isEmpty()) {
            stringBuilder.append(string);
            for (Integer n : list) {
                if (n < 10) {
                    stringBuilder.append('0');
                }
                stringBuilder.append(n);
            }
        }
    }

    private void processMove(StringBuilder stringBuilder, Move move) {
        int n = move.getFirstPosition();
        int n2 = move.getLastPosition();
        if (n < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n);
        if (n2 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n2);
    }

    @Override
    public byte[] processData() {
        return this.processedData.getBytes();
    }

    @Override
    public boolean appendToFile() {
        return AppPrefs.getProperty("appendGameToEnd", true);
    }
}

