/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.export;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import net.damaq.core.AppPrefs;
import net.damaq.core.managers.Game;
import net.damaq.core.managers.HistoryManager;
import net.damaq.export.Exporter;
import net.damaq.gamestyle.interfaces.Board;
import net.damaq.gamestyle.interfaces.GameStyle;
import net.damaq.pdn.PDNGame;

public class PDNExporter
implements Exporter {
    private Game game;
    private PDNGame pdnGame;

    public PDNExporter(Game game, PDNGame pDNGame) {
        this.game = game;
        this.pdnGame = pDNGame;
    }

    public void init() {
        GameStyle gameStyle = this.game.getManager().getCurrentGameStyle();
        Board board = gameStyle.newStartBoard();
        HistoryManager historyManager = this.game.getHistoryManager();
        Board board2 = historyManager.getFirstBoard();
        if (!board2.equals(board)) {
            this.pdnGame.setFENDescription(gameStyle, board2);
        }
        this.pdnGame.setGametypeSection(gameStyle.getPDNGameType());
        this.pdnGame.setMoves(this.game.getManager().getCurrentGameStyle(), historyManager.getMoveList(), historyManager.startsBlack());
    }

    public byte[] processData() {
        byte[] byArray;
        String string = AppPrefs.getProperty("pdnCharset", Charset.defaultCharset().name());
        try {
            byArray = this.pdnGame.toString().getBytes(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = this.pdnGame.toString().getBytes();
        }
        return byArray;
    }

    public boolean appendToFile() {
        return AppPrefs.getProperty("appendGameToEnd", true);
    }
}

