/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.gamestyle;

import java.util.Arrays;
import java.util.List;
import net.damaq.gamestyle.Side;
import net.damaq.gamestyle.interfaces.Board;
import net.damaq.gamestyle.interfaces.Move;
import net.damaq.gamestyle.interfaces.MoveGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBoard
implements Board {
    protected byte[] board;
    protected final MoveGenerator generator;
    private int hashcode = -1;

    protected AbstractBoard(MoveGenerator moveGenerator, byte[] byArray) {
        this.generator = moveGenerator;
        this.board = byArray;
    }

    @Override
    public final boolean isSideToMove(Side side) {
        if (this.generator.isWhiteOnMove(this.board)) {
            return side == Side.WHITES;
        }
        return side == Side.BLACKS;
    }

    @Override
    public final void setStartPosition() {
        this.generator.setStartPosition(this.board);
    }

    public final byte[] getRAWBoard() {
        return this.board;
    }

    @Override
    public final boolean generateMoves(List<Move> list) {
        return this.generator.generateMoves(this.board, list);
    }

    @Override
    public final boolean generateWhiteMoves(List<Move> list) {
        return this.generator.generateWhiteMoves(this.board, list);
    }

    @Override
    public final boolean generateBlackMoves(List<Move> list) {
        return this.generator.generateBlackMoves(this.board, list);
    }

    @Override
    public final Board doCopy() {
        AbstractBoard abstractBoard;
        try {
            abstractBoard = (AbstractBoard)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        int n = this.board.length;
        abstractBoard.board = new byte[n];
        System.arraycopy(this.board, 0, abstractBoard.board, 0, n);
        return abstractBoard;
    }

    public final boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        return Arrays.equals(((AbstractBoard)object).board, this.board);
    }

    public final int hashCode() {
        if (this.hashcode == -1) {
            this.hashcode = Arrays.hashCode(this.board);
        }
        return this.hashcode;
    }

    public final String toString() {
        return Arrays.toString(this.board);
    }

    protected final void resetHashcode() {
        this.hashcode = -1;
    }
}

