/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.gamestyle;

import net.damaq.gamestyle.NotSupportedGameStyleException;
import net.damaq.gamestyle.interfaces.GameStyle;
import net.damaq.gamestyle.international.GameStyle50;
import net.damaq.pdn.PDNGame;

public final class GameStyleFactory {
    private static final GameStyleFactory instance = new GameStyleFactory();
    public static final int INTERNATIONAL_DRAUGHTS = 20;
    private GameStyle50 gameStyle50 = null;

    public static GameStyleFactory getInstance() {
        return instance;
    }

    public final GameStyle getDefaultGameInstance() {
        return this.internationalDraughts();
    }

    public final GameStyle getGameStyleInstance(int n) throws NotSupportedGameStyleException {
        if (n != 20) {
            throw new NotSupportedGameStyleException();
        }
        return this.internationalDraughts();
    }

    public static GameStyle getSupportedGameStyle(PDNGame pDNGame) throws NotSupportedGameStyleException {
        if (GameStyleFactory.isSupported(pDNGame)) {
            return new GameStyle50();
        }
        throw new NotSupportedGameStyleException();
    }

    private GameStyle internationalDraughts() {
        if (this.gameStyle50 == null) {
            this.gameStyle50 = new GameStyle50();
        }
        return this.gameStyle50;
    }

    private static boolean isSupported(PDNGame pDNGame) {
        return new GameStyle50().isSupported(pDNGame);
    }
}

