/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.gamestyle;

import net.damaq.core.AppPrefs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Piece {
    WHITE_PIECE,
    BLACK_PIECE,
    WHITE_KING,
    BLACK_KING,
    NOTHING;


    public static boolean isKing(Piece piece) {
        return piece == BLACK_KING || piece == WHITE_KING;
    }

    public static boolean isWhite(Piece piece) {
        return piece == WHITE_PIECE || piece == WHITE_KING;
    }

    public static String getAsCode(Piece piece) {
        switch (piece) {
            case WHITE_PIECE: {
                return AppPrefs.getProperty("exWhitePiece", "ww");
            }
            case WHITE_KING: {
                return AppPrefs.getProperty("exWhiteKing", "wk");
            }
            case BLACK_PIECE: {
                return AppPrefs.getProperty("exBlackPiece", "bb");
            }
            case BLACK_KING: {
                return AppPrefs.getProperty("exBlackKing", "bk");
            }
        }
        return AppPrefs.getProperty("exBlackBar", "..");
    }

    public static char getAsFontCode(Piece piece) {
        switch (piece) {
            case WHITE_PIECE: {
                return 'w';
            }
            case WHITE_KING: {
                return 'W';
            }
            case BLACK_PIECE: {
                return 'b';
            }
            case BLACK_KING: {
                return 'B';
            }
        }
        return 'x';
    }
}

