/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.gamestyle;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.logging.Logger;
import net.damaq.gamestyle.HistoryTable;
import net.damaq.gamestyle.Side;
import net.damaq.gamestyle.ThinkingStyle;
import net.damaq.gamestyle.interfaces.Board;
import net.damaq.gamestyle.interfaces.GameStyle;
import net.damaq.gamestyle.interfaces.Move;

public final class Thinking {
    private static final Logger logger = Logger.getLogger(Thinking.class.getName());
    private static final int STOP = 32765;
    private static final int INFINITY = Integer.MAX_VALUE;
    private static final int MINUS_INFINITY = Integer.MIN_VALUE;
    private static final Move MOVE_INTERRUPTION = null;
    private ThinkingStyle st;
    private static int counter = 0;
    private static int cutOffWhite = 0;
    private static int cutOffBlack = 0;
    private boolean interruption;
    private HistoryTable historyTable;

    public final void stopThink() {
        this.interruption = true;
    }

    private int whitesBranch(Board board, int n, int n2) {
        ++counter;
        if (n == 0) {
            return board.evaluation();
        }
        LinkedList<Move> linkedList = new LinkedList<Move>();
        boolean bl = board.generateWhiteMoves(linkedList);
        if (linkedList.isEmpty()) {
            return board.evaluation();
        }
        if (!bl) {
            --n;
        }
        this.historyTable.sortMoves(linkedList);
        int n3 = Integer.MIN_VALUE;
        ListIterator listIterator = linkedList.listIterator();
        do {
            Board board2 = board.doCopy();
            Move move = (Move)listIterator.next();
            if (bl) {
                board2.doMoveJumpWhite(move);
            } else {
                board2.doMoveWhite(move);
            }
            this.debug("whites", n, move, -100);
            int n4 = this.blacksBranch(board2, n, n3);
            this.debug("whites - eval", n, move, n4);
            if (n2 < n4) {
                assert (n2 != Integer.MAX_VALUE);
                n3 = n4;
                ++cutOffWhite;
                this.historyTable.addCutOffMove(move, n);
                break;
            }
            if (n4 > n3) {
                n3 = n4;
            }
            if (!this.interruption && n4 != 32765) continue;
            n3 = 32765;
            break;
        } while (listIterator.hasNext());
        this.debug("whites - final", n, null, n3);
        linkedList.clear();
        return n3;
    }

    private int blacksBranch(Board board, int n, int n2) {
        ++counter;
        if (n == 0) {
            return board.evaluation();
        }
        LinkedList<Move> linkedList = new LinkedList<Move>();
        boolean bl = board.generateBlackMoves(linkedList);
        if (linkedList.isEmpty()) {
            return board.evaluation();
        }
        if (!bl) {
            --n;
        }
        int n3 = Integer.MAX_VALUE;
        this.historyTable.sortMoves(linkedList);
        ListIterator listIterator = linkedList.listIterator();
        do {
            Board board2 = board.doCopy();
            Move move = (Move)listIterator.next();
            if (bl) {
                board2.doMoveJumpBlack(move);
            } else {
                board2.doMoveBlack(move);
            }
            this.debug("blacks", n, move, -100);
            int n4 = this.whitesBranch(board2, n, n3);
            this.debug("blacks eval", n, move, n4);
            if (n2 > n4) {
                assert (n2 != Integer.MIN_VALUE);
                n3 = n4;
                ++cutOffBlack;
                this.historyTable.addCutOffMove(move, n);
                break;
            }
            if (n4 < n3) {
                n3 = n4;
            }
            if (!this.interruption && n4 != 32765) continue;
            n3 = 32765;
            break;
        } while (listIterator.hasNext());
        this.debug("blacks - final", n, null, n3);
        linkedList.clear();
        return n3;
    }

    private Move bestMoveWhite(Board board, ThinkingStyle thinkingStyle) {
        LinkedList<Move> linkedList = new LinkedList<Move>();
        boolean bl = board.generateWhiteMoves(linkedList);
        if (!linkedList.isEmpty()) {
            Move move = MOVE_INTERRUPTION;
            if (linkedList.size() > 1) {
                int n;
                this.st = thinkingStyle;
                int n2 = Integer.MIN_VALUE;
                this.historyTable.sortMoves(linkedList);
                ListIterator listIterator = linkedList.listIterator();
                do {
                    Board board2 = board.doCopy();
                    Move move2 = (Move)listIterator.next();
                    if (bl) {
                        board2.doMoveJumpWhite(move2);
                    } else {
                        board2.doMoveWhite(move2);
                    }
                    this.debug("white branch", thinkingStyle.maxDepth - 1, move2, 0);
                    n = this.blacksBranch(board2, thinkingStyle.maxDepth - 1, n2);
                    this.debug("white branch", thinkingStyle.maxDepth - 1, move2, n);
                    if (n <= n2) continue;
                    n2 = n;
                    move = move2;
                } while (!this.interruption && n != 32765 && listIterator.hasNext());
            } else {
                move = (Move)linkedList.iterator().next();
            }
            Move move3 = move != null ? move.doCopy() : null;
            linkedList.clear();
            return move3;
        }
        return MOVE_INTERRUPTION;
    }

    private Move bestMoveBlack(Board board, ThinkingStyle thinkingStyle) {
        ArrayList<Move> arrayList = new ArrayList<Move>();
        boolean bl = board.generateBlackMoves(arrayList);
        if (!arrayList.isEmpty()) {
            Move move = MOVE_INTERRUPTION;
            if (arrayList.size() > 1) {
                int n;
                this.st = thinkingStyle;
                int n2 = Integer.MAX_VALUE;
                this.historyTable.sortMoves(arrayList);
                ListIterator listIterator = arrayList.listIterator();
                do {
                    Board board2 = board.doCopy();
                    Move move2 = (Move)listIterator.next();
                    if (bl) {
                        board2.doMoveJumpBlack(move2);
                    } else {
                        board2.doMoveBlack(move2);
                    }
                    this.debug("black branch", thinkingStyle.maxDepth - 1, move2, -100);
                    n = this.whitesBranch(board2, thinkingStyle.maxDepth - 1, n2);
                    this.debug("black branch", thinkingStyle.maxDepth - 1, move2, n);
                    if (n >= n2) continue;
                    n2 = n;
                    move = move2;
                } while (!this.interruption && n != 32765 && listIterator.hasNext());
            } else {
                move = (Move)arrayList.iterator().next();
            }
            Move move3 = move != null ? move.doCopy() : null;
            arrayList.clear();
            return move3;
        }
        return MOVE_INTERRUPTION;
    }

    private void debug(String string, int n, Move move, int n2) {
        if (n2 > -1000000) {
            return;
        }
        for (int i = n; i <= this.st.maxDepth; ++i) {
            System.out.print(" ");
        }
        if (n2 == -100) {
            System.out.printf("%s %d %s\n", string, n, move == null ? "   " : move);
        } else {
            System.out.printf("%s %d %s %d\n", string, n, move == null ? "   " : move, n2);
        }
    }

    public final Move findBestMove(GameStyle gameStyle, Board board, ThinkingStyle thinkingStyle) {
        this.historyTable = gameStyle.getHistoryTable();
        this.historyTable.newSearch();
        this.interruption = false;
        cutOffBlack = 0;
        cutOffWhite = 0;
        counter = 0;
        board.initEvaluation();
        Move move = board.isSideToMove(Side.WHITES) ? this.bestMoveWhite(board, thinkingStyle) : this.bestMoveBlack(board, thinkingStyle);
        logger.info("counter " + counter);
        logger.info("cut offs white " + cutOffWhite);
        logger.info("cut offs black " + cutOffBlack);
        return move;
    }
}

