/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.gamestyle;

import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import net.damaq.gamestyle.Side;
import net.damaq.gamestyle.ThinkingStyle;
import net.damaq.gamestyle.interfaces.Board;
import net.damaq.gamestyle.interfaces.Move;

public final class Thinking2 {
    private static final int STOP = 32765;
    private static final int INFINITY = Integer.MAX_VALUE;
    private static final int MINUS_INFINITY = Integer.MIN_VALUE;
    private static final Move MOVE_INTERRUPTION = null;
    private ThinkingStyle st;
    private static int counter = 0;
    private boolean interruption;
    private Comparator<ValuePos> maxComparator = new MaxComparator();
    private Comparator<ValuePos> minComparator = new MinComparator();

    public final void stopThink() {
        this.interruption = true;
    }

    private int whitesBranch(Board board, int n, int n2) {
        Board board2;
        ++counter;
        if (n == 0) {
            return board.evaluation();
        }
        LinkedList<Move> linkedList = new LinkedList<Move>();
        boolean bl = board.generateWhiteMoves(linkedList);
        int n3 = linkedList.size();
        if (n3 == 0) {
            return board.evaluation();
        }
        if (!bl) {
            --n;
        }
        int n4 = Integer.MIN_VALUE;
        int n5 = 0;
        ValuePos[] valuePosArray = new ValuePos[n3];
        if (bl) {
            for (Move move : linkedList) {
                board2 = board.doCopy();
                board2.doMoveJumpWhite(move);
                valuePosArray[n5++] = new ValuePos(board2);
            }
        } else {
            for (Move move : linkedList) {
                board2 = board.doCopy();
                board2.doMoveWhite(move);
                valuePosArray[n5++] = new ValuePos(board2);
            }
        }
        Arrays.sort(valuePosArray, this.maxComparator);
        for (ValuePos valuePos : valuePosArray) {
            this.debug("whites", n, valuePos.move, -100);
            int n6 = this.blacksBranch(valuePos.board, n, n4);
            this.debug("whites - eval", n, valuePos.move, n6);
            if (n2 < n6) {
                n4 = n6;
                break;
            }
            if (n6 > n4) {
                n4 = n6;
            }
            if (!this.interruption && n6 != 32765) continue;
            n4 = 32765;
            break;
        }
        this.debug("whites - final", n, null, n4);
        linkedList.clear();
        return n4;
    }

    private int blacksBranch(Board board, int n, int n2) {
        Board board2;
        ++counter;
        if (n == 0) {
            return board.evaluation();
        }
        LinkedList<Move> linkedList = new LinkedList<Move>();
        boolean bl = board.generateBlackMoves(linkedList);
        int n3 = linkedList.size();
        if (n3 == 0) {
            return board.evaluation();
        }
        if (!bl) {
            --n;
        }
        int n4 = Integer.MAX_VALUE;
        int n5 = 0;
        ValuePos[] valuePosArray = new ValuePos[n3];
        if (bl) {
            for (Move move : linkedList) {
                board2 = board.doCopy();
                board2.doMoveJumpBlack(move);
                valuePosArray[n5++] = new ValuePos(board2);
            }
        } else {
            for (Move move : linkedList) {
                board2 = board.doCopy();
                board2.doMoveBlack(move);
                valuePosArray[n5++] = new ValuePos(board2);
            }
        }
        Arrays.sort(valuePosArray, this.minComparator);
        for (ValuePos valuePos : valuePosArray) {
            this.debug("blacks", n, valuePos.move, -100);
            int n6 = this.whitesBranch(valuePos.board, n, n4);
            this.debug("blacks eval", n, valuePos.move, n6);
            if (n2 > n6) {
                n4 = n6;
                break;
            }
            if (n6 < n4) {
                n4 = n6;
            }
            if (!this.interruption && n6 != 32765) continue;
            n4 = 32765;
            break;
        }
        this.debug("blacks - final", n, null, n4);
        linkedList.clear();
        return n4;
    }

    private Move bestMoveWhite(Board board, ThinkingStyle thinkingStyle) {
        LinkedList<Move> linkedList = new LinkedList<Move>();
        boolean bl = board.generateWhiteMoves(linkedList);
        int n = linkedList.size();
        if (n > 0) {
            Move move = MOVE_INTERRUPTION;
            if (n > 1) {
                this.st = thinkingStyle;
                int n2 = Integer.MIN_VALUE;
                int n3 = 0;
                ValuePos[] valuePosArray = new ValuePos[n];
                for (Move move2 : linkedList) {
                    Board board2 = board.doCopy();
                    if (bl) {
                        board2.doMoveJumpWhite(move2);
                    } else {
                        board2.doMoveWhite(move2);
                    }
                    valuePosArray[n3++] = new ValuePos(board2, move2);
                }
                Arrays.sort(valuePosArray, this.maxComparator);
                for (ValuePos valuePos : valuePosArray) {
                    Move move3 = valuePos.move;
                    this.debug("white branch", thinkingStyle.maxDepth - 1, move3, 0);
                    int n4 = this.blacksBranch(valuePos.board, thinkingStyle.maxDepth - 1, n2);
                    this.debug("white branch", thinkingStyle.maxDepth - 1, move3, n4);
                    if (n4 > n2) {
                        n2 = n4;
                        move = move3;
                    }
                    if (!this.interruption && n4 != 32765) {
                        continue;
                    }
                    break;
                }
            } else {
                move = (Move)linkedList.iterator().next();
            }
            Move move4 = move != null ? move.doCopy() : null;
            linkedList.clear();
            return move4;
        }
        return MOVE_INTERRUPTION;
    }

    private Move bestMoveBlack(Board board, ThinkingStyle thinkingStyle) {
        LinkedList<Move> linkedList = new LinkedList<Move>();
        boolean bl = board.generateBlackMoves(linkedList);
        if (!linkedList.isEmpty()) {
            Move move = MOVE_INTERRUPTION;
            int n = linkedList.size();
            if (n > 1) {
                this.st = thinkingStyle;
                int n2 = Integer.MAX_VALUE;
                int n3 = 0;
                ValuePos[] valuePosArray = new ValuePos[n];
                for (Move move2 : linkedList) {
                    Board board2 = board.doCopy();
                    if (bl) {
                        board2.doMoveJumpBlack(move2);
                    } else {
                        board2.doMoveBlack(move2);
                    }
                    valuePosArray[n3++] = new ValuePos(board2, move2);
                }
                Arrays.sort(valuePosArray, this.minComparator);
                for (ValuePos valuePos : valuePosArray) {
                    Move move2;
                    move2 = valuePos.move;
                    this.debug("black branch", thinkingStyle.maxDepth - 1, move2, -100);
                    int n4 = this.whitesBranch(valuePos.board, thinkingStyle.maxDepth - 1, n2);
                    this.debug("black branch", thinkingStyle.maxDepth - 1, move2, n4);
                    if (n4 < n2) {
                        n2 = n4;
                        move = move2;
                    }
                    if (!this.interruption && n4 != 32765) {
                        continue;
                    }
                    break;
                }
            } else {
                move = (Move)linkedList.iterator().next();
            }
            Move move3 = move != null ? move.doCopy() : null;
            linkedList.clear();
            return move3;
        }
        return MOVE_INTERRUPTION;
    }

    private void debug(String string, int n, Move move, int n2) {
        if (n2 > -1000000) {
            return;
        }
        for (int i = n; i <= this.st.maxDepth; ++i) {
            System.out.print(" ");
        }
        if (n2 == -100) {
            System.out.printf("%s %d %s\n", string, n, move == null ? "   " : move);
        } else {
            System.out.printf("%s %d %s %d\n", string, n, move == null ? "   " : move, n2);
        }
    }

    public final Move findBestMove(Board board, ThinkingStyle thinkingStyle) {
        this.interruption = false;
        counter = 0;
        Move move = board.isSideToMove(Side.WHITES) ? this.bestMoveWhite(board, thinkingStyle) : this.bestMoveBlack(board, thinkingStyle);
        System.out.println("counter" + counter);
        return move;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MinComparator
    implements Comparator<ValuePos> {
        private MinComparator() {
        }

        @Override
        public int compare(ValuePos valuePos, ValuePos valuePos2) {
            return valuePos.eval < valuePos2.eval ? -1 : (valuePos.eval == valuePos2.eval ? 0 : 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MaxComparator
    implements Comparator<ValuePos> {
        private MaxComparator() {
        }

        @Override
        public int compare(ValuePos valuePos, ValuePos valuePos2) {
            return valuePos.eval < valuePos2.eval ? 1 : (valuePos.eval == valuePos2.eval ? 0 : -1);
        }
    }

    private static class ValuePos {
        private Board board;
        private int eval;
        private Move move;

        public ValuePos(Board board) {
            this.board = board;
            this.eval = board.evaluation();
        }

        ValuePos(Board board, Move move) {
            this.board = board;
            this.eval = board.evaluation();
            this.move = move;
        }
    }
}

