/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.gamestyle.international;

import java.util.List;
import net.damaq.gamestyle.AbstractBoard;
import net.damaq.gamestyle.Piece;
import net.damaq.gamestyle.Side;
import net.damaq.gamestyle.interfaces.Move;
import net.damaq.gamestyle.interfaces.MoveGenerator;
import net.damaq.gamestyle.international.Board50Consts;
import net.damaq.gamestyle.international.Move50;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Board50Old
extends AbstractBoard {
    public Board50Old(MoveGenerator moveGenerator) {
        super(moveGenerator, new byte[51]);
    }

    public Board50Old(MoveGenerator moveGenerator, byte[] byArray) {
        super(moveGenerator, byArray);
    }

    @Override
    public final List<Integer> doMove(Move move, boolean bl) {
        return this.generator.doMove(((Move50)move).getRAWMove(), this.board, bl);
    }

    @Override
    public final Piece get(int n) {
        switch (this.board[n]) {
            case -2: {
                return Piece.BLACK_PIECE;
            }
            case 2: {
                return Piece.WHITE_PIECE;
            }
            case 9: {
                return Piece.WHITE_KING;
            }
            case -9: {
                return Piece.BLACK_KING;
            }
        }
        return Piece.NOTHING;
    }

    @Override
    public final Piece get(int n, int n2) {
        return this.get(Board50Consts.GETNUM_SMALL[n][n2]);
    }

    @Override
    public final void set(int n, Piece piece) {
        switch (piece) {
            case BLACK_PIECE: {
                this.board[n] = -2;
                break;
            }
            case WHITE_PIECE: {
                this.board[n] = 2;
                break;
            }
            case WHITE_KING: {
                this.board[n] = 9;
                break;
            }
            case BLACK_KING: {
                this.board[n] = -9;
                break;
            }
            default: {
                this.board[n] = 0;
            }
        }
        this.resetHashcode();
    }

    @Override
    public final void setEmpty() {
        for (int i = 1; i < 51; ++i) {
            this.board[i] = 0;
        }
    }

    @Override
    public final void setWithUpgrade(int n, Piece piece) {
        if (n >= 1 && n <= 5 && piece == Piece.WHITE_PIECE) {
            piece = Piece.WHITE_KING;
        }
        if (n >= 46 && n <= 50 && piece == Piece.BLACK_PIECE) {
            piece = Piece.BLACK_KING;
        }
        this.set(n, piece);
    }

    @Override
    public final int getMaxBoardLength() {
        return 50;
    }

    @Override
    public final int getBoardWidth() {
        return 10;
    }

    @Override
    public final int quickEvaluation() {
        int n = 0;
        int n2 = 1;
        do {
            n += this.board[n2];
        } while (++n2 < 51);
        return n;
    }

    @Override
    public final int evaluation() {
        int n = 0;
        int n2 = 1;
        do {
            n += this.board[n2];
        } while (++n2 < 51);
        n2 = 1;
        do {
            if (Board50Consts.isBlack(this.board[n2])) {
                --n;
            }
            if (!Board50Consts.isWhite(this.board[45 + n2])) continue;
            ++n;
        } while (++n2 < 6);
        n2 = 0;
        do {
            byte by;
            if (Board50Consts.isWhite(by = this.board[6 + n2])) {
                ++n;
            } else if (by != 0) {
                --n;
            }
            by = this.board[15 + n2];
            if (Board50Consts.isWhite(by)) {
                ++n;
                continue;
            }
            if (by == 0) continue;
            --n;
        } while ((n2 += 10) <= 20);
        return n;
    }

    @Override
    public final int getPosition(int n, int n2) {
        return Board50Consts.GETNUM_SMALL[n][n2];
    }

    @Override
    public final boolean isOurs(int n) {
        assert (this.board[0] != 0);
        return this.board[0] * this.board[n] > 0;
    }

    @Override
    public final void setSideToMove(Side side) {
        switch (side) {
            case WHITES: {
                this.board[0] = 2;
                break;
            }
            case BLACKS: {
                this.board[0] = -2;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public final void setWhitesToMove() {
        this.board[0] = 2;
    }

    public final void setBlacksToMove() {
        this.board[0] = -2;
    }

    @Override
    public final void doMoveWhite(Move move) {
        this.generator.doMoveWhite(((Move50)move).getRAWMove(), this.board, 0);
    }

    @Override
    public final void doMoveBlack(Move move) {
        this.generator.doMoveBlack(((Move50)move).getRAWMove(), this.board, 0);
    }

    @Override
    public final void doMoveJumpWhite(Move move) {
        this.generator.doMoveJumpWhite(((Move50)move).getRAWMove(), this.board, 0);
    }

    @Override
    public final void doMoveJumpBlack(Move move) {
        this.generator.doMoveJumpBlack(((Move50)move).getRAWMove(), this.board, 0);
    }

    @Override
    public final int[] getCounts() {
        int n = 0;
        int n2 = 0;
        block4: for (int i = 1; i < 51; ++i) {
            switch (this.board[i]) {
                case -9: 
                case -2: {
                    ++n;
                    continue block4;
                }
                case 2: 
                case 9: {
                    ++n2;
                    continue block4;
                }
            }
        }
        return new int[]{n2, n};
    }

    @Override
    public void initEvaluation() {
    }
}

