/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.gamestyle.international;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import net.damaq.core.Lng;
import net.damaq.core.managers.HistoryItem;
import net.damaq.damexchange.messages.MoveMessage;
import net.damaq.gamestyle.AbstractGameStyle;
import net.damaq.gamestyle.HistoryTable;
import net.damaq.gamestyle.NotConvertibleException;
import net.damaq.gamestyle.Piece;
import net.damaq.gamestyle.Side;
import net.damaq.gamestyle.interfaces.Board;
import net.damaq.gamestyle.interfaces.Move;
import net.damaq.gamestyle.interfaces.MoveGenerator;
import net.damaq.gamestyle.international.Board50;
import net.damaq.gamestyle.international.HistoryTable50;
import net.damaq.gamestyle.international.Move50;
import net.damaq.gamestyle.international.MoveGenerator50;
import net.damaq.pdn.PDNFENDescription;
import net.damaq.pdn.PDNGame;
import net.damaq.pdn.PDNGameType;
import net.damaq.pdn.PDNMove;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GameStyle50
extends AbstractGameStyle {
    public static final int PDN_CODE = 20;
    private static final Logger logger = Logger.getLogger(GameStyle50.class.getName());
    private final MoveGenerator generator = new MoveGenerator50();
    private final LinkedList<Move> moveList = new LinkedList();
    private static Board startPosition = null;
    private static final int WHITE_MAN_COUNT = 0;
    private static final int WHITE_KING_COUNT = 1;
    private static final int BLACK_MAN_COUNT = 2;
    private static final int BLACK_KING_COUNT = 3;

    public GameStyle50() {
        super(true);
    }

    @Override
    public final Board newBoardInstance() {
        return new Board50(this.generator);
    }

    @Override
    public Board newBoardInstance(String string) throws NotConvertibleException {
        int n = string.length();
        if (n >= 51) {
            throw new NotConvertibleException("Invalid board notation for this game style");
        }
        Board50 board50 = (Board50)this.newBoardInstance();
        byte[] byArray = board50.getRAWBoard();
        block6: for (int i = 0; i < n; ++i) {
            switch (string.charAt(i)) {
                case 'w': {
                    byArray[i + 1] = 2;
                    continue block6;
                }
                case 'z': {
                    byArray[i + 1] = -2;
                    continue block6;
                }
                case 'W': {
                    byArray[i + 1] = 9;
                    continue block6;
                }
                case 'Z': {
                    byArray[i + 1] = -9;
                    continue block6;
                }
            }
        }
        return board50;
    }

    @Override
    public final int maxPiecesForSide() {
        return 20;
    }

    @Override
    public Move newMoveInstance(Board board, MoveMessage moveMessage) throws NotConvertibleException {
        boolean bl;
        boolean bl2 = board.generateMoves(this.moveList);
        Set<Integer> set = moveMessage.getCapturedPieces();
        int n = set.size();
        boolean bl3 = bl = n > 0;
        if (bl2 ^ bl) {
            throw new NotConvertibleException("Move is not a jump: " + moveMessage);
        }
        int n2 = moveMessage.getFromField();
        int n3 = moveMessage.getToField();
        for (Move move : this.moveList) {
            List<Integer> list;
            if (move.getFirstPosition() != n2 || move.getLastPosition() != n3) continue;
            boolean bl4 = true;
            if (n > 0 && (list = board.doCopy().doMove(move, true)).size() == n) {
                for (Integer n4 : list) {
                    if (set.contains(n4)) continue;
                    bl4 = false;
                    break;
                }
            }
            if (!bl4) continue;
            this.moveList.clear();
            return move;
        }
        this.moveList.clear();
        throw new NotConvertibleException("Unexpected move :" + moveMessage);
    }

    @Override
    public final Move newMoveInstance(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length + 1];
        byArray2[0] = (byte)byArray.length;
        System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
        return new Move50(byArray2);
    }

    @Override
    public final Move newMoveInstance(Board board, PDNMove pDNMove) throws NotConvertibleException {
        boolean bl = board.generateMoves(this.moveList);
        if (bl ^ pDNMove.isJump()) {
            throw new NotConvertibleException("Move is not a jump: " + pDNMove);
        }
        if (!pDNMove.isNumeric()) {
            throw new NotConvertibleException("Move is not in numeric notation :" + pDNMove);
        }
        List<Object> list = pDNMove.getMove();
        int n = (Integer)list.get(0);
        int n2 = list.size();
        int n3 = (Integer)list.get(n2 - 1);
        for (Move move : this.moveList) {
            if (move.getFirstPosition() != n || move.getLastPosition() != n3) continue;
            boolean bl2 = true;
            if (n2 > 2) {
                for (int i = 1; i < n2 - 1; ++i) {
                    if (move.getPosition(i + 1) == ((Integer)list.get(i)).intValue()) continue;
                    bl2 = false;
                    break;
                }
            }
            if (!bl2) continue;
            this.moveList.clear();
            return move;
        }
        this.moveList.clear();
        throw new NotConvertibleException("Unexpected move :" + pDNMove);
    }

    public final Board newBoardInstance(byte[] byArray) {
        return new Board50(this.generator, byArray);
    }

    @Override
    public final boolean isDraw(List<HistoryItem> list) {
        HistoryItem historyItem;
        int[] nArray;
        HistoryItem historyItem2;
        int[] nArray2;
        int n;
        int n2 = list.size();
        if (n2 < 9) {
            return false;
        }
        HistoryItem historyItem3 = list.get(n2 - 1);
        Board board = historyItem3.getBoard();
        int[] nArray3 = historyItem3.getCounts();
        int n3 = 0;
        for (n = n2 - 5; n >= 0; n -= 4) {
            HistoryItem historyItem4 = list.get(n);
            Board board2 = historyItem4.getBoard();
            if (!Arrays.equals(nArray3, historyItem4.getCounts()) || board.hashCode() != board2.hashCode() || ++n3 != 2) continue;
            logger.info("Draw: #1");
            return true;
        }
        if (n2 > 50) {
            n = 1;
            boolean bl = true;
            int n4 = n2 - 1 - 50;
            for (int i = n2 - 2; i > n4; --i) {
                Board board3;
                HistoryItem historyItem5 = list.get(i);
                if (historyItem5.isJumps()) {
                    n = 0;
                }
                if (!Piece.isKing((board3 = historyItem5.getBoard()).get(historyItem5.getMove().getFirstPosition()))) {
                    bl = false;
                }
                if (n == 0 && !bl) break;
            }
            if (n != 0 || bl) {
                logger.info("Draw: #2");
                return true;
            }
        }
        if (n2 > 32 && ((nArray2 = (historyItem2 = list.get(n = n2 - 1 - 32)).getCounts())[0] == 3 && nArray2[1] <= 3 || nArray2[0] <= 3 && nArray2[1] == 3)) {
            int[] nArray4 = GameStyle50.getDetailedCounts(((Board50)historyItem2.getBoard()).getRAWBoard());
            assert (nArray4[0] + nArray4[1] == nArray2[0]);
            assert (nArray4[2] + nArray4[3] == nArray2[1]);
            if (nArray4[0] == 0 && nArray4[2] == 0) {
                logger.info("Draw: #3");
                return true;
            }
        }
        if (n2 > 10 && (nArray = (historyItem = list.get(n = n2 - 1 - 10)).getCounts())[0] <= 2 && nArray[1] <= 2) {
            int[] nArray5 = GameStyle50.getDetailedCounts(((Board50)historyItem.getBoard()).getRAWBoard());
            assert (nArray5[0] + nArray5[1] == nArray[0]);
            assert (nArray5[2] + nArray5[3] == nArray[1]);
            if (nArray5[1] > 1 && nArray5[3] > 1) {
                logger.info("Draw: #4");
                return true;
            }
        }
        return false;
    }

    @Override
    public final int[] getDetailedCounts(Board board) {
        return GameStyle50.getDetailedCounts(((Board50)board).getRAWBoard());
    }

    private static int[] getDetailedCounts(byte[] byArray) {
        int[] nArray = new int[4];
        block6: for (int i = 1; i < 51; ++i) {
            switch (byArray[i]) {
                case 2: {
                    nArray[0] = nArray[0] + 1;
                    continue block6;
                }
                case 9: {
                    nArray[1] = nArray[1] + 1;
                    continue block6;
                }
                case -2: {
                    nArray[2] = nArray[2] + 1;
                    continue block6;
                }
                case -9: {
                    nArray[3] = nArray[3] + 1;
                    continue block6;
                }
            }
        }
        return nArray;
    }

    @Override
    public final List<Integer>[] getDetailedPositions(Board board) {
        return GameStyle50.getDetailedPositions(((Board50)board).getRAWBoard());
    }

    private static List<Integer>[] getDetailedPositions(byte[] byArray) {
        List[] listArray = new List[4];
        ArrayList<Integer> arrayList = new ArrayList<Integer>(20);
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>(20);
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>(20);
        ArrayList<Integer> arrayList4 = new ArrayList<Integer>(20);
        block6: for (int i = 1; i < 51; ++i) {
            switch (byArray[i]) {
                case 2: {
                    arrayList.add(i);
                    continue block6;
                }
                case 9: {
                    arrayList3.add(i);
                    continue block6;
                }
                case -2: {
                    arrayList2.add(i);
                    continue block6;
                }
                case -9: {
                    arrayList4.add(i);
                    continue block6;
                }
            }
        }
        listArray[0] = arrayList;
        listArray[1] = arrayList3;
        listArray[2] = arrayList2;
        listArray[3] = arrayList4;
        return listArray;
    }

    @Override
    public final Board newBoardInstance(PDNFENDescription pDNFENDescription) throws NotConvertibleException {
        if (!pDNFENDescription.isNumeric()) {
            throw new NotConvertibleException("Not supported FEN description");
        }
        Map<Object, Piece> map = pDNFENDescription.getFENBoard();
        byte[] byArray = new byte[51];
        block6: for (Object object : map.keySet()) {
            int n = (Integer)object;
            if (n >= 1 && n < 51) {
                switch (map.get(object)) {
                    case BLACK_KING: {
                        byArray[n] = -9;
                        continue block6;
                    }
                    case WHITE_KING: {
                        byArray[n] = 9;
                        continue block6;
                    }
                    case WHITE_PIECE: {
                        byArray[n] = 2;
                        continue block6;
                    }
                    case BLACK_PIECE: {
                        byArray[n] = -2;
                        continue block6;
                    }
                }
                byArray[n] = 0;
                continue;
            }
            throw new NotConvertibleException("Invalid FEN description");
        }
        byArray[0] = pDNFENDescription.isWhiteStarts() ? 2 : -2;
        return new Board50(this.generator, byArray);
    }

    @Override
    public final boolean isSupported(PDNGame pDNGame) {
        PDNGameType pDNGameType = pDNGame.getGameTypeSection();
        if (pDNGameType != null && pDNGameType.getTypeNumber() != 20) {
            return false;
        }
        PDNFENDescription pDNFENDescription = pDNGame.getFENDescription();
        if (pDNFENDescription != null && !pDNFENDescription.isNumeric()) {
            return false;
        }
        List<PDNMove> list = pDNGame.getMoveList();
        return list.isEmpty() || !(list.get(0).isBlackStarts() ? list.size() > 1 && !list.get(1).isNumeric() : !list.get(0).isNumeric());
    }

    @Override
    public final int getPDNCode() {
        return 20;
    }

    @Override
    public final String getPDNGameType() {
        return "20";
    }

    @Override
    public final String getReadableName() {
        return Lng.getLabel("gamestyle.intdraughts");
    }

    @Override
    public final Board newStartBoard() {
        if (startPosition == null) {
            startPosition = this.newBoardInstance();
            startPosition.setStartPosition();
            startPosition.setSideToMove(Side.WHITES);
        }
        return startPosition.doCopy();
    }

    @Override
    public final String toPDN(Move move, boolean bl, boolean bl2) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        byte[] byArray = ((Move50)move).getRAWMove();
        byte by = byArray[1];
        stringBuilder.append(by);
        int n2 = byArray[0];
        int n3 = n = bl ? 2 : n2;
        while (n <= n2) {
            by = byArray[n];
            stringBuilder.append(bl2 ? (char)'x' : '-');
            stringBuilder.append(by);
            ++n;
        }
        return stringBuilder.toString();
    }

    @Override
    public final String toString(Move move, boolean bl, boolean bl2) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        byte[] byArray = ((Move50)move).getRAWMove();
        byte by = byArray[1];
        if (by < 10) {
            stringBuilder.append(' ');
        }
        stringBuilder.append(by);
        int n2 = byArray[0];
        int n3 = n = bl ? 2 : n2;
        while (n <= n2) {
            by = byArray[n];
            stringBuilder.append(bl2 ? (char)'x' : '\u2013');
            if (by < 10) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(by);
            ++n;
        }
        return stringBuilder.toString();
    }

    @Override
    public HistoryTable getHistoryTable() {
        return HistoryTable50.getInstance();
    }
}

