/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.gamestyle.international;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.damaq.gamestyle.HistoryTable;
import net.damaq.gamestyle.interfaces.Move;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoryTable50
implements HistoryTable {
    private static final HistoryTable instance = new HistoryTable50();
    private static int[][] activeHistory = new int[51][51];
    private static final int DIVISION_THRESHOLD = 1;
    private MoveComparator moveComparator = new MoveComparator();

    private HistoryTable50() {
    }

    public static HistoryTable getInstance() {
        return instance;
    }

    @Override
    public void cleanUp() {
        this.cleanUp(activeHistory);
    }

    private void cleanUp(int[][] nArray) {
        for (int i = 0; i < 51; ++i) {
            for (int j = 0; j < 51; ++j) {
                nArray[i][j] = 0;
            }
        }
    }

    @Override
    public void sortMoves(List<Move> list) {
        Collections.sort(list, this.moveComparator);
    }

    @Override
    public void addCutOffMove(Move move, int n) {
        int[] nArray = activeHistory[move.getFirstPosition()];
        int n2 = move.getLastPosition();
        nArray[n2] = nArray[n2] + (2 << n);
    }

    @Override
    public void newSearch() {
        this.newSearch(activeHistory);
    }

    private void newSearch(int[][] nArray) {
        for (int i = 0; i < 51; ++i) {
            int n = 0;
            while (n < 51) {
                int[] nArray2 = nArray[i];
                int n2 = n++;
                nArray2[n2] = nArray2[n2] >> 1;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MoveComparator
    implements Comparator<Move> {
        private MoveComparator() {
        }

        @Override
        public int compare(Move move, Move move2) {
            if (activeHistory[move.getFirstPosition()][move.getLastPosition()] > activeHistory[move2.getFirstPosition()][move2.getLastPosition()]) {
                return -1;
            }
            return 1;
        }
    }
}

