/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.gamestyle.international;

import java.util.LinkedList;
import java.util.List;
import net.damaq.gamestyle.interfaces.Move;
import net.damaq.gamestyle.interfaces.MoveGenerator;
import net.damaq.gamestyle.international.Board50Consts;
import net.damaq.gamestyle.international.Move50;
import net.damaq.gamestyle.international.MoveGenConsts;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MoveGenerator50
implements MoveGenerator {
    private int maximum;
    private List<Move> moves;

    MoveGenerator50() {
    }

    @Override
    public final List<Integer> doMove(byte[] byArray, byte[] byArray2, boolean bl) {
        int n;
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        for (n = 1; n < byArray[0]; ++n) {
            int n2;
            int n3 = byArray[n];
            int n4 = n2 = n3 - byArray[n + 1] > 0 ? -5 : 5;
            if (MoveGenConsts.COORDS_X[n3] > MoveGenConsts.COORDS_X[byArray[n + 1]]) {
                --n2;
            }
            int n5 = MoveGenConsts.LINEAR_MOVE[n3][8];
            n3 += n2 + (n5++ & 1);
            while (n3 != byArray[n + 1]) {
                if (byArray2[n3] * byArray2[0] < 0) {
                    linkedList.add(n3);
                }
                if (bl) {
                    byArray2[n3] = 0;
                }
                n3 += n2 + (n5++ & 1);
            }
        }
        int n6 = byArray2[byArray[1]];
        byArray2[byArray[1]] = 0;
        byArray2[byArray[n]] = byArray[n] < 6 && Board50Consts.isWhite(byArray2[0]) ? 9 : (byArray[n] > 45 && Board50Consts.isBlack(byArray2[0]) ? -9 : n6);
        byArray2[0] = (byte)(0 - byArray2[0]);
        return linkedList;
    }

    @Override
    public final int doMoveWhite(byte[] byArray, byte[] byArray2, int n) {
        byte by = byArray[2];
        if (by < 6) {
            byArray2[by] = 9;
            n += 9 - byArray2[byArray[1]];
        } else {
            byArray2[by] = byArray2[byArray[1]];
        }
        byArray2[byArray[1]] = 0;
        byArray2[0] = -2;
        return n;
    }

    @Override
    public final int doMoveBlack(byte[] byArray, byte[] byArray2, int n) {
        byte by = byArray[2];
        if (by > 45) {
            byArray2[by] = -9;
            n += -9 - byArray2[byArray[1]];
        } else {
            byArray2[by] = byArray2[byArray[1]];
        }
        byArray2[byArray[1]] = 0;
        byArray2[0] = 2;
        return n;
    }

    @Override
    public final int doMoveJumpWhite(byte[] byArray, byte[] byArray2, int n) {
        if (byArray2[byArray[1]] == 2) {
            byte by = 1;
            int n2 = 0;
            do {
                switch (byArray[by] - byArray[by + 1]) {
                    case 11: {
                        n2 = MoveGenConsts.LINEAR_MOVE[byArray[by]][1];
                        break;
                    }
                    case 9: {
                        n2 = MoveGenConsts.LINEAR_MOVE[byArray[by]][3];
                        break;
                    }
                    case -9: {
                        n2 = MoveGenConsts.LINEAR_MOVE[byArray[by]][5];
                        break;
                    }
                    case -11: {
                        n2 = MoveGenConsts.LINEAR_MOVE[byArray[by]][7];
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                n -= byArray2[n2];
                byArray2[n2] = 0;
            } while (++by < byArray[0]);
            byArray2[byArray[1]] = 0;
            if (byArray[by] <= 5) {
                byArray2[byArray[by]] = 9;
                n += 7;
            } else {
                byArray2[byArray[by]] = 2;
            }
        } else {
            for (int i = 1; i < byArray[0]; ++i) {
                int n3;
                byte by = byArray[i];
                byte by2 = byArray[i + 1];
                int n4 = n3 = by - by2 > 0 ? -5 : 5;
                if (MoveGenConsts.COORDS_X[by] > MoveGenConsts.COORDS_X[by2]) {
                    --n3;
                }
                int n5 = MoveGenConsts.LINEAR_MOVE[by][8];
                by = (byte)(by + (n3 + (n5++ & 1)));
                while (by != by2) {
                    n -= byArray2[by];
                    byArray2[by] = 0;
                    by = (byte)(by + (n3 + (n5++ & 1)));
                }
            }
            byArray2[byArray[1]] = 0;
            byArray2[byArray[i]] = 9;
        }
        byArray2[0] = -2;
        return n;
    }

    @Override
    public final int doMoveJumpBlack(byte[] byArray, byte[] byArray2, int n) {
        if (byArray2[byArray[1]] == -2) {
            byte by = 1;
            int n2 = 0;
            do {
                switch (byArray[by] - byArray[by + 1]) {
                    case 11: {
                        n2 = MoveGenConsts.LINEAR_MOVE[byArray[by]][1];
                        break;
                    }
                    case 9: {
                        n2 = MoveGenConsts.LINEAR_MOVE[byArray[by]][3];
                        break;
                    }
                    case -9: {
                        n2 = MoveGenConsts.LINEAR_MOVE[byArray[by]][5];
                        break;
                    }
                    case -11: {
                        n2 = MoveGenConsts.LINEAR_MOVE[byArray[by]][7];
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                n -= byArray2[n2];
                byArray2[n2] = 0;
            } while (++by < byArray[0]);
            byArray2[byArray[1]] = 0;
            if (byArray[by] > 45) {
                byArray2[byArray[by]] = -9;
                n -= 7;
            } else {
                byArray2[byArray[by]] = -2;
            }
        } else {
            for (int i = 1; i < byArray[0]; ++i) {
                int n3;
                byte by = byArray[i];
                byte by2 = byArray[i + 1];
                int n4 = n3 = by - by2 > 0 ? -5 : 5;
                if (MoveGenConsts.COORDS_X[by] > MoveGenConsts.COORDS_X[by2]) {
                    --n3;
                }
                int n5 = MoveGenConsts.LINEAR_MOVE[by][8];
                by = (byte)(by + (n3 + (n5++ & 1)));
                while (by != by2) {
                    n -= byArray2[by];
                    byArray2[by] = 0;
                    by = (byte)(by + (n3 + (n5++ & 1)));
                }
            }
            byArray2[byArray[1]] = 0;
            byArray2[byArray[i]] = -9;
        }
        byArray2[0] = 2;
        return n;
    }

    @Override
    public final void setStartPosition(byte[] byArray) {
        int n;
        byArray[0] = 2;
        for (n = 1; n < 21; ++n) {
            byArray[n] = -2;
        }
        for (n = 21; n < 31; ++n) {
            byArray[n] = 0;
        }
        for (n = 31; n < 51; ++n) {
            byArray[n] = 2;
        }
    }

    private void saveMove(byte[] byArray) {
        if (byArray[0] > this.maximum) {
            this.maximum = byArray[0];
            this.moves.clear();
            byte[] byArray2 = new byte[this.maximum + 1];
            System.arraycopy(byArray, 0, byArray2, 0, this.maximum + 1);
            this.moves.add(new Move50(byArray2));
        } else if (this.maximum > 1 && byArray[0] == this.maximum) {
            byte[] byArray3 = new byte[this.maximum + 1];
            System.arraycopy(byArray, 0, byArray3, 0, this.maximum + 1);
            this.moves.add(new Move50(byArray3));
        }
    }

    private void jumpsWhitePiece(byte by, byte[] byArray, byte[] byArray2) {
        byte by2;
        boolean bl = true;
        byte by3 = MoveGenConsts.LINEAR_MOVE[by][1];
        byte by4 = MoveGenConsts.LINEAR_MOVE[by][0];
        if (byArray2[by4] == 0 && Board50Consts.isBlack(byArray2[by3])) {
            bl = false;
            byArray[0] = (byte)(byArray[0] + 1);
            byArray[byArray[0]] = by4;
            by2 = byArray2[by3];
            byArray2[by3] = 2;
            this.jumpsWhitePiece(by4, byArray, byArray2);
            byArray2[by3] = by2;
            byArray[0] = (byte)(byArray[0] - 1);
        }
        by3 = MoveGenConsts.LINEAR_MOVE[by][3];
        by4 = MoveGenConsts.LINEAR_MOVE[by][2];
        if (byArray2[by4] == 0 && Board50Consts.isBlack(byArray2[by3])) {
            bl = false;
            byArray[0] = (byte)(byArray[0] + 1);
            byArray[byArray[0]] = by4;
            by2 = byArray2[by3];
            byArray2[by3] = 2;
            this.jumpsWhitePiece(by4, byArray, byArray2);
            byArray2[by3] = by2;
            byArray[0] = (byte)(byArray[0] - 1);
        }
        by3 = MoveGenConsts.LINEAR_MOVE[by][5];
        by4 = MoveGenConsts.LINEAR_MOVE[by][4];
        if (byArray2[by4] == 0 && Board50Consts.isBlack(byArray2[by3])) {
            bl = false;
            byArray[0] = (byte)(byArray[0] + 1);
            byArray[byArray[0]] = by4;
            by2 = byArray2[by3];
            byArray2[by3] = 2;
            this.jumpsWhitePiece(by4, byArray, byArray2);
            byArray2[by3] = by2;
            byArray[0] = (byte)(byArray[0] - 1);
        }
        by3 = MoveGenConsts.LINEAR_MOVE[by][7];
        by4 = MoveGenConsts.LINEAR_MOVE[by][6];
        if (byArray2[by4] == 0 && Board50Consts.isBlack(byArray2[by3])) {
            byArray[0] = (byte)(byArray[0] + 1);
            byArray[byArray[0]] = by4;
            by2 = byArray2[by3];
            byArray2[by3] = 2;
            this.jumpsWhitePiece(by4, byArray, byArray2);
            byArray2[by3] = by2;
            byArray[0] = (byte)(byArray[0] - 1);
        } else if (bl) {
            this.saveMove(byArray);
        }
    }

    private void jumpsBlackPiece(byte by, byte[] byArray, byte[] byArray2) {
        byte by2;
        boolean bl = true;
        byte by3 = MoveGenConsts.LINEAR_MOVE[by][1];
        byte by4 = MoveGenConsts.LINEAR_MOVE[by][0];
        if (byArray2[by4] == 0 && Board50Consts.isWhite(byArray2[by3])) {
            bl = false;
            byArray[0] = (byte)(byArray[0] + 1);
            byArray[byArray[0]] = by4;
            by2 = byArray2[by3];
            byArray2[by3] = -2;
            this.jumpsBlackPiece(by4, byArray, byArray2);
            byArray2[by3] = by2;
            byArray[0] = (byte)(byArray[0] - 1);
        }
        by3 = MoveGenConsts.LINEAR_MOVE[by][3];
        by4 = MoveGenConsts.LINEAR_MOVE[by][2];
        if (byArray2[by4] == 0 && Board50Consts.isWhite(byArray2[by3])) {
            bl = false;
            byArray[0] = (byte)(byArray[0] + 1);
            byArray[byArray[0]] = by4;
            by2 = byArray2[by3];
            byArray2[by3] = -2;
            this.jumpsBlackPiece(by4, byArray, byArray2);
            byArray2[by3] = by2;
            byArray[0] = (byte)(byArray[0] - 1);
        }
        by3 = MoveGenConsts.LINEAR_MOVE[by][5];
        by4 = MoveGenConsts.LINEAR_MOVE[by][4];
        if (byArray2[by4] == 0 && Board50Consts.isWhite(byArray2[by3])) {
            bl = false;
            byArray[0] = (byte)(byArray[0] + 1);
            byArray[byArray[0]] = by4;
            by2 = byArray2[by3];
            byArray2[by3] = -2;
            this.jumpsBlackPiece(by4, byArray, byArray2);
            byArray2[by3] = by2;
            byArray[0] = (byte)(byArray[0] - 1);
        }
        by3 = MoveGenConsts.LINEAR_MOVE[by][7];
        by4 = MoveGenConsts.LINEAR_MOVE[by][6];
        if (byArray2[by4] == 0 && Board50Consts.isWhite(byArray2[by3])) {
            byArray[0] = (byte)(byArray[0] + 1);
            byArray[byArray[0]] = by4;
            by2 = byArray2[by3];
            byArray2[by3] = -2;
            this.jumpsBlackPiece(by4, byArray, byArray2);
            byArray2[by3] = by2;
            byArray[0] = (byte)(byArray[0] - 1);
        } else if (bl) {
            this.saveMove(byArray);
        }
    }

    private void jumpsWhiteKing(byte[] byArray, byte[] byArray2) {
        int n = 127;
        byte by = MoveGenConsts.COORDS_X[byArray[byArray[0]]];
        byte by2 = MoveGenConsts.COORDS_Y[byArray[byArray[0]]];
        for (int i = 0; i <= 3; ++i) {
            boolean bl = false;
            byte by3 = (byte)(by + MoveGenConsts.DIRECTION_2X[i]);
            byte by4 = (byte)(by2 + MoveGenConsts.DIRECTION_2Y[i]);
            while (MoveGenConsts.GETNUM[by4][by3] != 0) {
                byte by5 = MoveGenConsts.GETNUM[by4][by3];
                int n2 = MoveGenConsts.GETNUM[by4 - MoveGenConsts.DIRECTION_Y[i]][by3 - MoveGenConsts.DIRECTION_X[i]];
                if (byArray2[n2] != 0 && byArray2[by5] != 0 || byArray2[by5] == 0 && Board50Consts.isWhite(byArray2[n2]) || bl && byArray2[by5] != 0) break;
                if (byArray2[by5] == 0 && (Board50Consts.isBlack(byArray2[n2]) || bl)) {
                    byArray[0] = (byte)(byArray[0] + 1);
                    byArray[byArray[0]] = by5;
                    this.saveMove(byArray);
                    if (!bl) {
                        bl = true;
                        n = n2;
                    }
                    byArray2[n2] = (byte)(0 - byArray2[n2]);
                    this.jumpsWhiteKing(byArray, byArray2);
                    byArray[0] = (byte)(byArray[0] - 1);
                }
                by3 = (byte)(by3 + MoveGenConsts.DIRECTION_X[i]);
                by4 = (byte)(by4 + MoveGenConsts.DIRECTION_Y[i]);
            }
            if (!bl) continue;
            byArray2[n] = (byte)(0 - byArray2[n]);
        }
    }

    private void jumpsBlackKing(byte[] byArray, byte[] byArray2) {
        int n = 127;
        byte by = MoveGenConsts.COORDS_X[byArray[byArray[0]]];
        byte by2 = MoveGenConsts.COORDS_Y[byArray[byArray[0]]];
        for (int n2 = 0; n2 <= 3; n2 = (int)((byte)(n2 + 1))) {
            boolean bl = false;
            byte by3 = (byte)(by + MoveGenConsts.DIRECTION_2X[n2]);
            byte by4 = (byte)(by2 + MoveGenConsts.DIRECTION_2Y[n2]);
            while (MoveGenConsts.GETNUM[by4][by3] != 0) {
                byte by5 = MoveGenConsts.GETNUM[by4][by3];
                int n3 = MoveGenConsts.GETNUM[by4 - MoveGenConsts.DIRECTION_Y[n2]][by3 - MoveGenConsts.DIRECTION_X[n2]];
                if (byArray2[n3] != 0 && byArray2[by5] != 0 || byArray2[by5] == 0 && Board50Consts.isBlack(byArray2[n3]) || bl && byArray2[by5] != 0) break;
                if (byArray2[by5] == 0 && (Board50Consts.isWhite(byArray2[n3]) || bl)) {
                    byArray[0] = (byte)(byArray[0] + 1);
                    byArray[byArray[0]] = by5;
                    this.saveMove(byArray);
                    if (!bl) {
                        bl = true;
                        n = n3;
                    }
                    byArray2[n3] = (byte)(0 - byArray2[n3]);
                    this.jumpsBlackKing(byArray, byArray2);
                    byArray[0] = (byte)(byArray[0] - 1);
                }
                by3 = (byte)(by3 + MoveGenConsts.DIRECTION_X[n2]);
                by4 = (byte)(by4 + MoveGenConsts.DIRECTION_Y[n2]);
            }
            if (!bl) continue;
            byArray2[n] = (byte)(0 - byArray2[n]);
        }
    }

    private void movesKing(byte by, byte[] byArray) {
        for (int i = 0; i <= 3; ++i) {
            int n = MoveGenConsts.COORDS_X[by] + MoveGenConsts.DIRECTION_X[i];
            int n2 = MoveGenConsts.COORDS_Y[by] + MoveGenConsts.DIRECTION_Y[i];
            while (byArray[MoveGenConsts.GETNUM[n2][n]] == 0) {
                this.addEasyMove(by, MoveGenConsts.GETNUM[n2][n]);
                n += MoveGenConsts.DIRECTION_X[i];
                n2 += MoveGenConsts.DIRECTION_Y[i];
            }
        }
    }

    private void movesWhitePiece(byte by, byte[] byArray) {
        if (byArray[MoveGenConsts.LINEAR_MOVE[by][1]] == 0) {
            this.addEasyMove(by, MoveGenConsts.LINEAR_MOVE[by][1]);
        }
        if (byArray[MoveGenConsts.LINEAR_MOVE[by][3]] == 0) {
            this.addEasyMove(by, MoveGenConsts.LINEAR_MOVE[by][3]);
        }
    }

    private void movesBlackPiece(byte by, byte[] byArray) {
        if (byArray[MoveGenConsts.LINEAR_MOVE[by][5]] == 0) {
            this.addEasyMove(by, MoveGenConsts.LINEAR_MOVE[by][5]);
        }
        if (byArray[MoveGenConsts.LINEAR_MOVE[by][7]] == 0) {
            this.addEasyMove(by, MoveGenConsts.LINEAR_MOVE[by][7]);
        }
    }

    private void addEasyMove(byte by, byte by2) {
        byte[] byArray = new byte[]{2, by, by2};
        this.moves.add(new Move50(byArray));
    }

    @Override
    public final boolean generateWhiteMoves(byte[] byArray, List<Move> list) {
        this.moves = list;
        byte[] byArray2 = new byte[22];
        byte[] byArray3 = new byte[21];
        this.maximum = 1;
        byArray3[0] = 0;
        byte by = 1;
        do {
            if (!Board50Consts.isWhite(byArray[by])) continue;
            byArray2[0] = 1;
            byArray2[1] = by;
            byArray3[0] = (byte)(byArray3[0] + 1);
            byArray3[byArray3[0]] = by;
            switch (byArray[by]) {
                case 9: {
                    byArray[by] = 0;
                    this.jumpsWhiteKing(byArray2, byArray);
                    byArray[by] = 9;
                    break;
                }
                case 2: {
                    byArray[by] = 0;
                    this.jumpsWhitePiece(by, byArray2, byArray);
                    byArray[by] = 2;
                }
            }
        } while ((by = (byte)((byte)(by + 1))) <= 50);
        if (this.maximum != 1) {
            return true;
        }
        block9: for (int i = 1; i <= byArray3[0]; ++i) {
            switch (byArray[byArray3[i]]) {
                case 2: {
                    this.movesWhitePiece(byArray3[i], byArray);
                    continue block9;
                }
                case 9: {
                    this.movesKing(byArray3[i], byArray);
                }
            }
        }
        return false;
    }

    @Override
    public final boolean generateBlackMoves(byte[] byArray, List<Move> list) {
        this.moves = list;
        byte[] byArray2 = new byte[22];
        byte[] byArray3 = new byte[22];
        this.maximum = 1;
        byArray3[0] = 0;
        byte by = 50;
        do {
            if (!Board50Consts.isBlack(byArray[by])) continue;
            byArray2[0] = 1;
            byArray2[1] = by;
            byArray3[0] = (byte)(byArray3[0] + 1);
            byArray3[byArray3[0]] = by;
            switch (byArray[by]) {
                case -9: {
                    byArray[by] = 0;
                    this.jumpsBlackKing(byArray2, byArray);
                    byArray[by] = -9;
                    break;
                }
                case -2: {
                    byArray[by] = 0;
                    this.jumpsBlackPiece(by, byArray2, byArray);
                    byArray[by] = -2;
                }
            }
        } while ((by = (byte)((byte)(by - 1))) != 0);
        if (this.maximum != 1) {
            return true;
        }
        int n = byArray3[0];
        block9: for (int i = 1; i <= n; ++i) {
            switch (byArray[byArray3[i]]) {
                case -2: {
                    this.movesBlackPiece(byArray3[i], byArray);
                    continue block9;
                }
                case -9: {
                    this.movesKing(byArray3[i], byArray);
                }
            }
        }
        return false;
    }

    @Override
    public final boolean generateMoves(byte[] byArray, List<Move> list) {
        return this.isWhiteOnMove(byArray) ? this.generateWhiteMoves(byArray, list) : this.generateBlackMoves(byArray, list);
    }

    @Override
    public final boolean isWhiteOnMove(byte[] byArray) {
        return Board50Consts.isWhite(byArray[0]);
    }

    @Override
    public final int getMaxBoardLength() {
        return 51;
    }
}

