/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;
import net.damaq.core.AppPrefs;
import net.damaq.core.MainApp;
import net.damaq.core.MainAppFrame;
import net.damaq.gui.LaF;
import net.damaq.gui.Skin;
import net.damaq.gui.SkinInfo;
import net.damaq.utilities.LogUtils;
import net.damaq.utilities.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LookAndFeels {
    public static final String SUBSTANCE = "org.jvnet.substance.SubstanceLookAndFeel";
    private static final Logger logger = Logger.getLogger(LookAndFeels.class.getName());
    private static final String LOOK_AND_FEEL_SELECTED_KEY = "lookAndFeel";
    private static final String LOOK_AND_FEEL_OPAQUE_KEY = "lafOpaque";
    private static final String THEME_SELECTED_KEY = "theme";
    private LaF selectedLookAndFeel;
    private final EventListenerList listenerList = new EventListenerList();
    private static final LookAndFeels instance = new LookAndFeels();
    public ClassLoader classLoader = this.initClassLoader();
    private Vector<LaF> availableLaFs = null;
    private Vector<SkinInfo> availableSkins = null;
    private Skin activeSkin;
    private static final Object SKIN_PROPERTIES = "skin.properties";
    private static final Object SKINS_DIR = "skins";
    private static final Object TEST_SUBSTANCE_THEME = "test.TestSubstanceTheme";

    public static LookAndFeels getInstance() {
        return instance;
    }

    private LookAndFeels() {
        String string = AppPrefs.getProperty(LOOK_AND_FEEL_SELECTED_KEY, SUBSTANCE);
        boolean bl = AppPrefs.getProperty(LOOK_AND_FEEL_OPAQUE_KEY, true);
        String string2 = AppPrefs.getProperty(THEME_SELECTED_KEY, null);
        this.selectedLookAndFeel = new LaF(string, "", string2, bl);
    }

    public Vector<SkinInfo> getAvailableSkins() {
        if (this.availableSkins == null) {
            this.availableSkins = new Vector(5);
            String string = AppPrefs.getAppPath() + SKINS_DIR;
            logger.config("Loading skins path " + string);
            File file = new File(string);
            File[] fileArray = file.listFiles(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return file.isDirectory();
                }
            });
            boolean bl = logger.isLoggable(Level.INFO);
            for (File file2 : fileArray) {
                SkinInfo skinInfo;
                File file3;
                if (bl) {
                    logger.info("Loading SkinInfo from the directory " + file2);
                }
                if (!(file3 = new File(Utils.addFileSeparator(file2.getPath()) + SKIN_PROPERTIES)).exists() || !(skinInfo = new SkinInfo(file3)).loadSkinInfo()) continue;
                this.availableSkins.add(skinInfo);
            }
        }
        return this.availableSkins;
    }

    private ClassLoader initClassLoader() {
        String string = AppPrefs.getAppPath() + "lib";
        logger.config("Loading plugin path " + string);
        File file = new File(string);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        FilenameFilter filenameFilter = new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.endsWith(".jar");
            }
        };
        ArrayList<URL> arrayList = new ArrayList<URL>();
        boolean bl = logger.isLoggable(Level.INFO);
        try {
            File[] fileArray;
            Object object;
            if (file.exists()) {
                object = file.listFiles(filenameFilter);
                fileArray = object;
                int n = fileArray.length;
                for (int i = 0; i < n; ++i) {
                    File file2 = fileArray[i];
                    arrayList.add(file2.toURL());
                    if (!bl) continue;
                    logger.config("Loading URL with a jar " + file2);
                }
            }
            if (((File)(object = new File(AppPrefs.getAppPath() + SKINS_DIR))).exists()) {
                logger.config("Loading skinPath path " + string);
                for (File file3 : fileArray = ((File)object).listFiles(new FilenameFilter(){

                    public boolean accept(File file, String string) {
                        return file.isDirectory();
                    }
                })) {
                    for (File file4 : file3.listFiles(filenameFilter)) {
                        arrayList.add(file4.toURL());
                        if (!bl) continue;
                        logger.config("Loading URL with a jar " + file4);
                    }
                }
            }
            classLoader = new URLClassLoader(arrayList.toArray(new URL[arrayList.size()]), classLoader);
            return classLoader;
        }
        catch (Exception exception) {
            LogUtils.processException(logger, exception);
            return classLoader;
        }
    }

    public final Vector<LaF> getAvailableLookAndFeels() {
        if (this.availableLaFs == null) {
            String string;
            String string2;
            this.availableLaFs = new Vector(5);
            Properties properties = Utils.loadProperties("resources/lookandfeels/lookandfeels.properties", true);
            int n = -1;
            while ((string2 = properties.getProperty(string = "laf" + ++n)) != null) {
                String string3;
                String string4;
                if (this.isPresent(string2) == null) continue;
                boolean bl = properties.getProperty(string + ".opaque", "true").equals("true");
                int n2 = -1;
                String string5 = properties.getProperty(string + ".name", string2);
                if (properties.getProperty(string + ".alone", "true").equals("true")) {
                    this.availableLaFs.add(new LaF(string2, string5, null, bl));
                }
                while ((string4 = properties.getProperty(string3 = string + ".theme" + ++n2, null)) != null) {
                    if (this.isPresent(string4) == null) continue;
                    String string6 = string5 + " - " + properties.getProperty(string3 + ".name", " - theme");
                    this.availableLaFs.add(new LaF(string2, string6, string4, bl));
                }
            }
        }
        return this.availableLaFs;
    }

    public LaF getSelectedLaF() {
        return this.selectedLookAndFeel;
    }

    public final void storeSelectedLaF(LaF laF) {
        AppPrefs.storeProperty(LOOK_AND_FEEL_SELECTED_KEY, laF.getClassName());
        AppPrefs.storeProperty(LOOK_AND_FEEL_OPAQUE_KEY, laF.isToolbarOpaque());
        if (laF.getThemeClass() == null) {
            AppPrefs.removeProperty(THEME_SELECTED_KEY);
        } else {
            AppPrefs.storeProperty(THEME_SELECTED_KEY, laF.getThemeClass());
        }
        this.selectedLookAndFeel = laF;
    }

    public final void loadLookAndFeelSettings() {
        this.activeSkin = this.loadActiveSkin();
        if (this.activeSkin == null) {
            logger.severe("Fatal error, loading of the default skin failed. Application will exit.");
            System.exit(-1);
        } else {
            this.activateSkin(this.activeSkin);
        }
        this.loadLookAndFeel(this.selectedLookAndFeel, false);
    }

    private Class<?> isPresent(String string) {
        if (string == null) {
            return null;
        }
        try {
            return this.classLoader.loadClass(string);
        }
        catch (UnsupportedClassVersionError unsupportedClassVersionError) {
            logger.info("Possible problem. Look and feel class/theme " + string + " cannot be instantied. Probably higher version of the JDK is required.");
            return null;
        }
        catch (Exception exception) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Possible problem.Look and feel class/theme " + string + " was not detected(not in /lib?).Check " + "resources/lookandfeels/lookandfeels.properties");
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean loadLookAndFeel(LaF laF, boolean bl) {
        String string = laF.getClassName();
        String string2 = laF.getThemeClass();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            this.initLaf(string, string2);
        }
        catch (Exception exception) {
            logger.warning(string + " was not found.");
            if (!string.equals(SUBSTANCE) && logger.isLoggable(Level.INFO)) {
                LogUtils.processException(logger, exception);
            }
            boolean bl2 = false;
            return bl2;
        }
        finally {
            if (bl) {
                MainAppFrame mainAppFrame = MainApp.getInstance().getMainAppFrame();
                mainAppFrame.getManagerDirector().beforeLookAndFeelUpdate();
                LookAndFeels.updateAllUIs();
                UIManager.getLookAndFeel().getDefaults();
                mainAppFrame.getManagerDirector().afterLookAndFeelUpdate();
                mainAppFrame.invalidate();
                mainAppFrame.validate();
                mainAppFrame.repaint();
            }
        }
        return true;
    }

    public Skin getActiveSkin() {
        return this.activeSkin;
    }

    private void initLafWithTheme(String string, MetalTheme metalTheme) throws Exception {
        Method method;
        LookAndFeel lookAndFeel = (LookAndFeel)this.classLoader.loadClass(string).newInstance();
        if (string.equals(SUBSTANCE)) {
            try {
                method = lookAndFeel.getClass().getMethod("setCurrentWatermark", String.class);
                method.invoke((Object)lookAndFeel, this.getActiveSkin().getWatermark());
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (metalTheme != null && lookAndFeel instanceof MetalLookAndFeel) {
            method = null;
            try {
                method = lookAndFeel.getClass().getMethod("setCurrentTheme", String.class);
                method.invoke((Object)lookAndFeel, metalTheme.getClass().getName());
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (method == null) {
                lookAndFeel.getClass().getMethod("setCurrentTheme", MetalTheme.class).invoke((Object)lookAndFeel, metalTheme);
            }
        }
        UIManager.put("ClassLoader", this.classLoader);
        UIManager.setLookAndFeel(lookAndFeel);
        UIManager.put("ClassLoader", this.classLoader);
    }

    private void initLaf(String string, String string2) throws Exception {
        if (!TEST_SUBSTANCE_THEME.equals(string2) && string.equals(SUBSTANCE)) {
            if (this.getActiveSkin().isLoaded() && this.getActiveSkin().getTheme() != null) {
                string2 = this.getActiveSkin().getTheme();
            }
            if (string2 == null) {
                string2 = "org.jvnet.substance.theme.SubstanceAquaTheme";
            }
        }
        if (string2 != null) {
            Class<?> clazz = this.isPresent(string2);
            if (clazz != null) {
                Object obj = clazz.newInstance();
                if (obj instanceof MetalTheme) {
                    this.initLafWithTheme(string, (MetalTheme)obj);
                } else {
                    logger.warning("Theme " + obj.getClass().getName() + " cannot be set.Theme is not an instance of Metaltheme");
                    this.initLafWithTheme(string, null);
                }
            }
        } else {
            this.initLafWithTheme(string, null);
        }
    }

    private void activateSkin(Skin skin) {
        AppPrefs.storeProperty("activeSkin", skin.identify());
        this.fireChangeEvent();
    }

    public synchronized void setSkin(SkinInfo skinInfo) {
        Skin skin = new Skin(skinInfo);
        if (skin.loadSkin()) {
            Skin skin2 = this.activeSkin;
            this.activeSkin = skin;
            this.activateSkin(skin);
            skin2.dispose();
            LaF laF = this.getSelectedLaF();
            if (laF.getClassName().equals(SUBSTANCE) && (laF.getThemeClass() == null || !laF.getThemeClass().equals(skin.getTheme()))) {
                this.loadLookAndFeel(laF, true);
            }
        }
    }

    private Skin loadDefaultSkin() {
        Vector<SkinInfo> vector = this.getAvailableSkins();
        if (!vector.isEmpty()) {
            SkinInfo skinInfo = vector.get(0);
            Skin skin = new Skin(skinInfo);
            if (skin.loadSkin()) {
                return skin;
            }
            logger.severe("Loading of the skin '" + skin + "' failed");
        }
        return null;
    }

    private Skin loadActiveSkin() {
        Skin skin;
        SkinInfo skinInfo;
        String string = AppPrefs.getProperty("activeSkin", null);
        if (string != null && (skinInfo = new SkinInfo(new File(string))).loadSkinInfo() && (skin = new Skin(skinInfo)).loadSkin()) {
            return skin;
        }
        return this.loadDefaultSkin();
    }

    private static void updateAllUIs() {
        Frame[] frameArray;
        for (Frame frame : frameArray = Frame.getFrames()) {
            LookAndFeels.updateWindowUI(frame);
        }
    }

    public static void updateWindowUI(Window window) {
        Window[] windowArray;
        try {
            LookAndFeels.updateComponentTreeUI(window);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (Window window2 : windowArray = window.getOwnedWindows()) {
            LookAndFeels.updateWindowUI(window2);
        }
    }

    private static void updateComponentTreeUI(Component component) {
        LookAndFeels.updateComponentTreeUI0(component);
        component.invalidate();
        component.validate();
        component.repaint();
    }

    private static void updateComponentTreeUI0(Component component) {
        Component[] componentArray = null;
        if (component instanceof JToolBar) {
            componentArray = ((JToolBar)component).getComponents();
            if (componentArray != null) {
                boolean bl = LookAndFeels.getInstance().getSelectedLaF().isToolbarOpaque();
                for (Component component2 : componentArray) {
                    LookAndFeels.updateComponentTreeUI0(component2);
                    if (!(component2 instanceof JComponent)) continue;
                    ((JComponent)component2).setOpaque(!bl);
                }
            }
            ((JComponent)component).updateUI();
        } else {
            if (component instanceof JComponent) {
                ((JComponent)component).updateUI();
            }
            if (component instanceof JMenu) {
                componentArray = ((JMenu)component).getMenuComponents();
            } else if (component instanceof Container) {
                componentArray = ((Container)component).getComponents();
            }
            if (componentArray != null) {
                for (Component component3 : componentArray) {
                    LookAndFeels.updateComponentTreeUI0(component3);
                }
            }
        }
    }

    public final void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public final void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    private void fireChangeEvent() {
        Object[] objectArray = this.listenerList.getListenerList();
        ChangeEvent changeEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            if (changeEvent == null) {
                changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
        }
    }
}

