/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Image;
import java.awt.Stroke;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Logger;
import net.damaq.gamestyle.Piece;
import net.damaq.gui.SelSquareType;
import net.damaq.gui.SkinInfo;
import net.damaq.utilities.LogUtils;
import net.damaq.utilities.Swinger;
import net.damaq.utilities.Utils;

public final class Skin {
    private static final Logger logger = Logger.getLogger(Skin.class.getName());
    private final SkinInfo info;
    private boolean loaded = false;
    private Image whiteKing;
    private Image blackKing;
    private Image whitePiece;
    private Image blackPiece;
    private Image whiteBar;
    private Image blackBar;
    private Image frameTop;
    private Image frameBottom;
    private Image frameLeft;
    private Image frameRight;
    private Image whiteKingZoomed;
    private Image blackKingZoomed;
    private Image whitePieceZoomed;
    private Image blackPieceZoomed;
    private Image whiteBarZoomed;
    private Image blackBarZoomed;
    private Color selectRectColor;
    private Color moveRectColor;
    private Color computerRectColor;
    private int rectangleSpacing;
    private Properties properties;
    private String parentFolder;
    private Stroke selStroke = null;
    private int rectangleWidth;
    private Color backgroundColor;
    private boolean backgroundTiled;
    private boolean backgroundStretched;
    private Image backgroundImage;
    private int zoomedSquareWidth;
    private String theme;
    private String watermark;

    public Skin(SkinInfo skinInfo) {
        this.info = skinInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized boolean loadSkin() {
        this.loaded = false;
        if (!this.info.isLoaded()) {
            return false;
        }
        this.properties = this.info.getProperties();
        this.parentFolder = this.info.getPropertiesFile().getParent();
        try {
            this.whiteBar = this.loadPicture("bars.white", "white.bmp");
            this.blackBar = this.loadPicture("bars.black", "black.bmp");
            this.whiteKing = this.loadPicture("pieces.whiteKing", "w_king.bmp");
            this.blackKing = this.loadPicture("pieces.blackKing", "b_king.bmp");
            this.whitePiece = this.loadPicture("pieces.whitePiece", "w_piece.bmp");
            this.blackPiece = this.loadPicture("pieces.blackPiece", "b_piece.bmp");
            this.frameTop = this.loadPicture("frames.top", "r_top.bmp");
            this.frameBottom = this.loadPicture("frames.bottom", "r_bottom.bmp");
            this.frameLeft = this.loadPicture("frames.left", "r_left.bmp");
            this.frameRight = this.loadPicture("frames.right", "r_right.bmp");
            this.selectRectColor = this.loadColor("rectangles.select_rect");
            this.moveRectColor = this.loadColor("rectangles.move_rect");
            this.computerRectColor = this.loadColor("rectangles.computer_rect");
            this.backgroundColor = this.loadColor("background.color");
            this.backgroundTiled = this.loadBoolean("background.tiled", true);
            this.backgroundStretched = this.loadBoolean("background.stretched", false);
            this.backgroundImage = this.loadPicture("background.image");
            this.rectangleWidth = Integer.parseInt(this.properties.getProperty("rectangles.width_rect", "2"));
            this.rectangleSpacing = Integer.parseInt(this.properties.getProperty("rectangles.spacing_rect", "1"));
            this.selStroke = new BasicStroke(this.rectangleWidth);
            this.theme = this.properties.getProperty("substanceTheme", null);
            this.watermark = this.properties.getProperty("substanceWatermark", null);
            this.loaded = true;
            boolean bl = true;
            return bl;
        }
        catch (NumberFormatException numberFormatException) {
            logger.severe("Skin " + this.toString() + " failed to load - invalid number parameter in the skin.properties.");
        }
        catch (IOException iOException) {
            logger.severe("Skin " + this.toString() + " failed to load");
            LogUtils.processException(logger, iOException);
        }
        finally {
            this.properties = null;
        }
        this.setSqWidth(this.whiteBar.getWidth(null));
        return this.loaded;
    }

    public final void setSqWidth(int n) {
        this.zoomedSquareWidth = n;
        this.updateZoomImages();
    }

    private void updateZoomImages() {
        this.whiteBarZoomed = this.zoomImage(this.whiteBar, this.whiteBarZoomed);
        this.blackBarZoomed = this.zoomImage(this.blackBar, this.blackBarZoomed);
        this.whiteKingZoomed = this.zoomImage(this.whiteKing, this.whiteKingZoomed);
        this.blackKingZoomed = this.zoomImage(this.blackKing, this.blackKingZoomed);
        this.whitePieceZoomed = this.zoomImage(this.whitePiece, this.whitePieceZoomed);
        this.blackPieceZoomed = this.zoomImage(this.blackPiece, this.blackPieceZoomed);
    }

    private Image zoomImage(Image image, Image image2) {
        if (image2 != null) {
            image2.flush();
        }
        return image.getScaledInstance(this.zoomedSquareWidth, -1, 4);
    }

    private Image loadPicture(String string, String string2) throws IOException {
        return Swinger.loadPicture(new File(Utils.addFileSeparator(this.parentFolder) + this.properties.getProperty(string, string2)));
    }

    private Image loadPicture(String string) throws IOException {
        String string2 = this.properties.getProperty(string, null);
        if (string2 != null) {
            return Swinger.loadPicture(new File(Utils.addFileSeparator(this.parentFolder) + string2));
        }
        return null;
    }

    private Color loadColor(String string) {
        return Color.decode(this.properties.getProperty(string, "0"));
    }

    private boolean loadBoolean(String string, boolean bl) {
        return Boolean.valueOf(this.properties.getProperty(string, String.valueOf(bl)));
    }

    public final int hashCode() {
        return this.info.hashCode();
    }

    public final boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Skin)) {
            return false;
        }
        Skin skin = (Skin)object;
        return this.info.equals(skin.getInfo());
    }

    public final String toString() {
        return this.info.toString();
    }

    public final synchronized boolean isLoaded() {
        return this.loaded;
    }

    public final Image getWhiteKing() {
        return this.whiteKing;
    }

    public final Image getBlackKing() {
        return this.blackKing;
    }

    public final Image getWhitePiece() {
        return this.whitePiece;
    }

    public final Image getBlackPiece() {
        return this.blackPiece;
    }

    public final Image getWhiteBar() {
        return this.whiteBar;
    }

    public final Image getBlackBar() {
        return this.blackBar;
    }

    public final Image getFrameTop() {
        return this.frameTop;
    }

    public final Image getFrameBottom() {
        return this.frameBottom;
    }

    public final Image getFrameLeft() {
        return this.frameLeft;
    }

    public final Image getFrameRight() {
        return this.frameRight;
    }

    public final Color getSelectRectColor() {
        return this.selectRectColor;
    }

    public final Color getMoveRectColor() {
        return this.moveRectColor;
    }

    public final Color getComputerRectColor() {
        return this.computerRectColor;
    }

    public final int getRectangleSpacing() {
        return this.rectangleSpacing;
    }

    public final Stroke getSelStroke() {
        return this.selStroke;
    }

    public final int getRectangleWidth() {
        return this.rectangleWidth;
    }

    public final Color getRectColor(SelSquareType selSquareType) {
        switch (selSquareType) {
            case START_MOVE: {
                return this.selectRectColor;
            }
            case END_MOVE: {
                return this.selectRectColor;
            }
            case MIDDLE_MOVE: {
                return this.moveRectColor;
            }
            case COMPUTER_MOVE: {
                return this.computerRectColor;
            }
        }
        return Color.BLACK;
    }

    public final Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public final boolean isBackgroundTiled() {
        return this.backgroundTiled;
    }

    public final boolean isBackgroundStretched() {
        return this.backgroundStretched;
    }

    public final Image getBackgroundImage() {
        return this.backgroundImage;
    }

    public final Image getPieceImageZoomed(Piece piece) {
        switch (piece) {
            case WHITE_PIECE: {
                return this.whitePieceZoomed;
            }
            case BLACK_PIECE: {
                return this.blackPieceZoomed;
            }
            case NOTHING: {
                return this.blackBarZoomed;
            }
            case BLACK_KING: {
                return this.blackKingZoomed;
            }
            case WHITE_KING: {
                return this.whiteKingZoomed;
            }
        }
        throw new IllegalStateException("Piece not identified");
    }

    public final Image getPieceImage(Piece piece) {
        switch (piece) {
            case WHITE_PIECE: {
                return this.whitePiece;
            }
            case BLACK_PIECE: {
                return this.blackPiece;
            }
            case NOTHING: {
                return this.blackBar;
            }
            case BLACK_KING: {
                return this.blackKing;
            }
            case WHITE_KING: {
                return this.whiteKing;
            }
        }
        return null;
    }

    public final String identify() {
        return this.info.getPropertiesFile().toString();
    }

    public final int getZoomedSquareWidth() {
        return this.zoomedSquareWidth;
    }

    public final Image getWhiteBarZoomed() {
        return this.whiteBarZoomed;
    }

    public String getTheme() {
        return this.theme;
    }

    public SkinInfo getInfo() {
        return this.info;
    }

    public synchronized void dispose() {
        this.whiteKing.flush();
        this.blackKing.flush();
        this.whitePiece.flush();
        this.blackPiece.flush();
        this.whiteBar.flush();
        this.blackBar.flush();
        this.frameTop.flush();
        this.frameBottom.flush();
        this.frameLeft.flush();
        this.frameRight.flush();
        this.whiteKingZoomed.flush();
        this.blackKingZoomed.flush();
        this.whitePieceZoomed.flush();
        this.blackPieceZoomed.flush();
        this.whiteBarZoomed.flush();
        this.blackBarZoomed.flush();
        this.backgroundImage.flush();
        this.whiteKing = null;
        this.blackKing = null;
        this.whitePiece = null;
        this.blackPiece = null;
        this.whiteBar = null;
        this.blackBar = null;
        this.frameTop = null;
        this.frameBottom = null;
        this.frameLeft = null;
        this.frameRight = null;
        this.whiteKingZoomed = null;
        this.blackKingZoomed = null;
        this.whitePieceZoomed = null;
        this.blackPieceZoomed = null;
        this.whiteBarZoomed = null;
        this.blackBarZoomed = null;
        this.backgroundImage = null;
        this.loaded = false;
    }

    public String getWatermark() {
        return this.watermark;
    }
}

