/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.gui;

import java.io.File;
import java.util.Properties;
import net.damaq.utilities.Utils;

public final class SkinInfo {
    private final File propertiesFile;
    private Properties properties = null;
    private boolean loaded = false;
    private String skinName = "unknown";
    private String skinAuthor = "unknown";

    public SkinInfo(File file) {
        this.propertiesFile = file;
    }

    public final boolean loadSkinInfo() {
        this.properties = this.propertiesFile.exists() ? Utils.loadProperties(this.propertiesFile.getPath(), false) : null;
        boolean bl = this.loaded = this.properties != null;
        if (this.loaded) {
            this.skinAuthor = this.properties.getProperty("info.author", "unknown");
            this.skinName = this.properties.getProperty("info.name", "unknown");
        }
        return this.loaded;
    }

    public final Properties getProperties() {
        return this.properties;
    }

    public final boolean isLoaded() {
        return this.loaded;
    }

    public final int hashCode() {
        return this.propertiesFile.hashCode();
    }

    public final boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof SkinInfo)) {
            return false;
        }
        SkinInfo skinInfo = (SkinInfo)object;
        return this.propertiesFile.equals(skinInfo.getPropertiesFile());
    }

    public final String getSkinName() {
        return this.skinName;
    }

    public final String getSkinAuthor() {
        return this.skinAuthor;
    }

    public final String toString() {
        return this.skinName;
    }

    final File getPropertiesFile() {
        return this.propertiesFile;
    }
}

