/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.pdn;

import java.util.HashMap;
import java.util.IllegalFormatException;
import java.util.Map;
import java.util.UnknownFormatConversionException;
import java.util.regex.Pattern;
import net.damaq.gamestyle.Piece;
import net.damaq.gamestyle.Side;
import net.damaq.gamestyle.interfaces.Board;
import net.damaq.gamestyle.interfaces.GameStyle;
import net.damaq.pdn.PDNSection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PDNFENDescription
extends PDNSection {
    private static final String SECTION_NAME = "FEN";
    private static final Pattern pattern1 = Pattern.compile("^(B|W):(B|W)((k)?[0-9]?[0-9](,(k)?[0-9]?[0-9])*)?:(B|W)((k)?[0-9]?[0-9](,(k)?[0-9]?[0-9])*)?\\.?$", 2);
    private static final Pattern pattern2 = Pattern.compile("^(B|W):(B|W)((k)?[a-j][0-9]{1,2}(,(k)?[a-j][0-9]{1,2})*)?:(B|W)((k)?[a-j][0-9]{1,2}(,(k)?[a-j][0-9]{1,2})*)?\\.?$", 2);
    private boolean whiteStarts = false;
    private final Map<Object, Piece> fenBoard = new HashMap<Object, Piece>();
    private boolean numeric;
    private boolean processed = false;

    public PDNFENDescription(String string) throws IllegalFormatException {
        super(SECTION_NAME);
        if (pattern1.matcher(string).matches()) {
            this.numeric = true;
        } else if (pattern2.matcher(string).matches()) {
            this.numeric = false;
        } else {
            throw new UnknownFormatConversionException(string);
        }
        this.stringValue = string;
        this.whiteStarts = string.charAt(0) == 'W';
    }

    public PDNFENDescription(GameStyle gameStyle, Board board) {
        super(SECTION_NAME);
        this.whiteStarts = board.isSideToMove(Side.WHITES);
        this.updateStringValue(gameStyle, board);
    }

    private void updateStringValue(GameStyle gameStyle, Board board) {
        int n = board.getMaxBoardLength();
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        block6: for (int i = 1; i <= n; ++i) {
            switch (board.get(i)) {
                case WHITE_PIECE: {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(',');
                    }
                    stringBuilder.append(gameStyle.boardPositionToString(i));
                    continue block6;
                }
                case WHITE_KING: {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(',');
                    }
                    stringBuilder.append('k').append(gameStyle.boardPositionToString(i));
                    continue block6;
                }
                case BLACK_PIECE: {
                    if (stringBuilder2.length() > 0) {
                        stringBuilder2.append(',');
                    }
                    stringBuilder2.append(gameStyle.boardPositionToString(i));
                    continue block6;
                }
                case BLACK_KING: {
                    if (stringBuilder2.length() > 0) {
                        stringBuilder2.append(',');
                    }
                    stringBuilder2.append('k').append(gameStyle.boardPositionToString(i));
                    continue block6;
                }
            }
        }
        StringBuilder stringBuilder3 = new StringBuilder();
        stringBuilder3.append(this.whiteStarts ? "W:" : "B:");
        stringBuilder3.append('W');
        stringBuilder3.append((CharSequence)stringBuilder);
        stringBuilder3.append(":B");
        stringBuilder3.append((CharSequence)stringBuilder2);
        stringBuilder3.append('.');
        this.stringValue = stringBuilder3.toString();
        this.processed = true;
    }

    private void processFen(String string) {
        int n;
        String[] stringArray;
        if (string.endsWith(".")) {
            string = string.substring(0, string.length() - 1);
        }
        if ((stringArray = string.substring(3, n = string.lastIndexOf(58)).toLowerCase().split(","))[0].length() > 0) {
            for (String string2 : stringArray) {
                if (string2.startsWith("k")) {
                    this.fenBoard.put(Integer.parseInt(string2.substring(1)), Piece.WHITE_KING);
                    continue;
                }
                this.fenBoard.put(Integer.parseInt(string2), Piece.WHITE_PIECE);
            }
        }
        if ((stringArray = string.substring(n + 2, string.length()).toLowerCase().split(","))[0].length() > 0) {
            for (String string2 : stringArray) {
                if (string2.startsWith("k")) {
                    this.fenBoard.put(Integer.parseInt(string2.substring(1)), Piece.BLACK_KING);
                    continue;
                }
                this.fenBoard.put(Integer.parseInt(string2), Piece.BLACK_PIECE);
            }
        }
    }

    public final boolean isNumeric() {
        return this.numeric;
    }

    public final Map<Object, Piece> getFENBoard() {
        if (!this.processed) {
            this.processFen(this.stringValue);
            this.processed = true;
        }
        return this.fenBoard;
    }

    public final boolean isWhiteStarts() {
        return this.whiteStarts;
    }
}

