/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.pdn;

import java.util.IllegalFormatException;
import java.util.LinkedList;
import java.util.List;
import net.damaq.core.AppPrefs;
import net.damaq.core.managers.HistoryItem;
import net.damaq.gamestyle.interfaces.Board;
import net.damaq.gamestyle.interfaces.GameStyle;
import net.damaq.pdn.GameStatus;
import net.damaq.pdn.PDNFENDescription;
import net.damaq.pdn.PDNGameType;
import net.damaq.pdn.PDNMove;
import net.damaq.pdn.PDNResultSection;
import net.damaq.pdn.PDNSection;
import net.damaq.pdn.PDNTextSection;
import net.damaq.utilities.Consts;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PDNGame {
    private final List<PDNSection> otherSections = new LinkedList<PDNSection>();
    private final List<PDNMove> moveList = new LinkedList<PDNMove>();
    private PDNSection eventSection = null;
    private PDNSection siteSection = null;
    private PDNSection whiteSection = null;
    private PDNSection blackSection = null;
    private PDNSection dateSection = null;
    private PDNSection roundSection = null;
    private PDNResultSection resultSection = null;
    private PDNGameType gametypeSection = new PDNGameType();
    private PDNFENDescription fenDescription = null;
    private static final String RESULT_SECTION = "RESULT";

    public final List<PDNSection> getOtherSections() {
        return this.otherSections;
    }

    public final List<PDNMove> getMoveList() {
        return this.moveList;
    }

    public final void addSection(String string, String string2) throws IllegalFormatException {
        if ((string = string.toUpperCase()).equals("EVENT")) {
            this.setEventSection(string2);
        } else if (string.equals("SITE")) {
            this.setSiteSection(string2);
        } else if (string.equals("DATE")) {
            this.setDateSection(string2);
        } else if (string.equals("ROUND")) {
            this.setRoundSection(string2);
        } else if (string.equals("WHITE")) {
            this.setWhiteSection(string2);
        } else if (string.equals("BLACK")) {
            this.setBlackSection(string2);
        } else if (string.equals("GAMETYPE")) {
            this.setGametypeSection(string2);
        } else if (string.equals("FEN")) {
            this.fenDescription = new PDNFENDescription(string2);
        } else if (!string.equals("SETUP")) {
            if (string.equals(RESULT_SECTION)) {
                this.resultSection = new PDNResultSection(string2);
            } else {
                this.otherSections.add(new PDNTextSection(string, string2));
            }
        }
    }

    public final void removeSection(String string) {
        if ((string = string.toUpperCase()).equals("EVENT")) {
            this.eventSection = null;
        } else if (string.equals("SITE")) {
            this.siteSection = null;
        } else if (string.equals("DATE")) {
            this.dateSection = null;
        } else if (string.equals("ROUND")) {
            this.roundSection = null;
        } else if (string.equals("WHITE")) {
            this.whiteSection = null;
        } else if (string.equals("BLACK")) {
            this.blackSection = null;
        } else if (string.equals("GAMETYPE")) {
            this.gametypeSection = null;
        } else if (string.equals("FEN")) {
            this.fenDescription = null;
        } else if (string.equals(RESULT_SECTION)) {
            this.resultSection = null;
        }
    }

    public final void addMove(PDNMove pDNMove) {
        this.moveList.add(pDNMove);
    }

    public final PDNSection getEventSection() {
        return this.eventSection;
    }

    public final PDNSection getSiteSection() {
        return this.siteSection;
    }

    public final PDNSection getWhiteSection() {
        return this.whiteSection;
    }

    public final PDNSection getBlackSection() {
        return this.blackSection;
    }

    public final PDNSection getDateSection() {
        return this.dateSection;
    }

    public final PDNSection getRoundSection() {
        return this.roundSection;
    }

    public final PDNResultSection getResultSection() {
        return this.resultSection;
    }

    public final PDNGameType getGameTypeSection() {
        return this.gametypeSection;
    }

    public final PDNFENDescription getFENDescription() {
        return this.fenDescription;
    }

    public final void setResultSection(PDNResultSection pDNResultSection) {
        this.resultSection = pDNResultSection;
    }

    public final void setFENDescription(GameStyle gameStyle, Board board) {
        this.fenDescription = new PDNFENDescription(gameStyle, board);
    }

    public final void setEventSection(String string) {
        this.eventSection = new PDNTextSection("Event", string);
    }

    public final void setSiteSection(String string) {
        this.siteSection = new PDNTextSection("Site", string);
    }

    public final void setWhiteSection(String string) {
        this.whiteSection = new PDNTextSection("White", string);
    }

    public final void setBlackSection(String string) {
        this.blackSection = new PDNTextSection("Black", string);
    }

    public final void setDateSection(String string) {
        this.dateSection = new PDNTextSection("Date", string);
    }

    public final void setRoundSection(String string) {
        this.roundSection = new PDNTextSection("Round", string);
    }

    public void setGametypeSection(String string) {
        this.gametypeSection = new PDNGameType(string);
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.eventSection.toPDNFormat());
        if (this.siteSection != null) {
            stringBuilder.append(this.siteSection.toPDNFormat());
        }
        if (this.whiteSection != null) {
            stringBuilder.append(this.whiteSection.toPDNFormat());
        }
        if (this.blackSection != null) {
            stringBuilder.append(this.blackSection.toPDNFormat());
        }
        if (this.roundSection != null) {
            stringBuilder.append(this.roundSection.toPDNFormat());
        }
        if (this.dateSection != null) {
            stringBuilder.append(this.dateSection.toPDNFormat());
        }
        stringBuilder.append(this.gametypeSection.toPDNFormat());
        if (this.fenDescription != null) {
            stringBuilder.append(new PDNTextSection("SetUp", "1").toPDNFormat());
            stringBuilder.append(this.fenDescription.toPDNFormat());
        }
        stringBuilder.append(this.resultSection.toPDNFormat());
        stringBuilder.append(Consts.LINE_SEPARATOR);
        int n = 0;
        int n2 = 0;
        StringBuilder stringBuilder2 = new StringBuilder(80);
        if (this.moveList.size() != 1 || !this.moveList.get(0).isBlackStarts()) {
            for (PDNMove pDNMove : this.moveList) {
                if (!(n2 & true)) {
                    PDNGame.addItem(stringBuilder, stringBuilder2, ++n + ". ");
                }
                PDNGame.addItem(stringBuilder, stringBuilder2, pDNMove.toString());
                stringBuilder2.append(' ');
                if (pDNMove.getComment() != null) {
                    this.processComment(stringBuilder, stringBuilder2, pDNMove.getComment());
                }
                ++n2;
            }
        }
        PDNGame.addItem(stringBuilder, stringBuilder2, this.resultSection.getStringValue());
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append(Consts.LINE_SEPARATOR);
        return stringBuilder.toString();
    }

    private void processComment(StringBuilder stringBuilder, StringBuilder stringBuilder2, String string) {
        String[] stringArray;
        string = "{" + string + "} ";
        for (String string2 : stringArray = string.split("\n")) {
            PDNGame.addItem(stringBuilder, stringBuilder2, string2);
        }
    }

    private static void addItem(StringBuilder stringBuilder, StringBuilder stringBuilder2, String string) {
        if (stringBuilder2.length() + string.length() > 80) {
            stringBuilder.append((CharSequence)stringBuilder2);
            stringBuilder.append(Consts.LINE_SEPARATOR);
            stringBuilder2.setLength(0);
        }
        stringBuilder2.append(string);
    }

    public final void setResultSection(GameStatus gameStatus) {
        this.resultSection = new PDNResultSection(gameStatus);
    }

    public final void setMoves(GameStyle gameStyle, List<HistoryItem> list, boolean bl) {
        this.moveList.clear();
        if (bl) {
            this.moveList.add(new PDNMove(true));
        }
        boolean bl2 = AppPrefs.getProperty("longMovesPDN", false);
        for (HistoryItem historyItem : list) {
            if (!historyItem.isMove()) continue;
            PDNMove pDNMove = new PDNMove(gameStyle, historyItem.getMove(), bl2, historyItem.isJumps());
            pDNMove.setComment(historyItem.getComment());
            this.moveList.add(pDNMove);
        }
    }
}

