/*
 * Decompiled with CFR 0.152.
 */
package net.damaq.pdn;

import java.util.IllegalFormatException;
import java.util.UnknownFormatConversionException;
import java.util.regex.Pattern;
import net.damaq.pdn.PDNSection;

public final class PDNGameType
extends PDNSection {
    private static final String SECTION_NAME = "GameType";
    private int typeNumber = -1;
    private boolean whiteStart = true;
    private int boardWidth = -1;
    private int boardHeight = -1;
    private NotationStartSide startSide = null;
    private Notation notation = null;
    private final boolean invertFlag = false;
    private boolean fullSpec = false;
    private boolean showFullSpec = false;
    private static final Pattern pattern = Pattern.compile("^[0-9]?[0-9](,(B|W),[0-9]?[0-9],[0-9]?[0-9],(A|N|S)(0|1|2|3),(0|1))?$");

    public PDNGameType() {
        super(SECTION_NAME);
        this.typeNumber = 20;
    }

    public PDNGameType(String string) throws IllegalFormatException {
        super(SECTION_NAME);
        if (!pattern.matcher(string).matches()) {
            throw new UnknownFormatConversionException(string);
        }
        this.stringValue = string;
        this.parseStringValue(string);
    }

    private void updateStringValue() {
        if (!this.fullSpec && !this.showFullSpec) {
            this.stringValue = String.valueOf(this.typeNumber);
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.typeNumber);
        stringBuilder.append(',');
        stringBuilder.append(this.whiteStart ? (char)'W' : 'B');
        stringBuilder.append(',');
        stringBuilder.append(this.boardWidth);
        stringBuilder.append(',');
        stringBuilder.append(this.boardHeight);
        stringBuilder.append(',');
        switch (this.notation) {
            case ALPHANUMERIC: {
                stringBuilder.append('A');
                break;
            }
            case NUMERIC: {
                stringBuilder.append('N');
                break;
            }
            case SAN: {
                stringBuilder.append('S');
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        switch (this.startSide) {
            case BOTTOM_LEFT: {
                stringBuilder.append('0');
                break;
            }
            case BOTTOM_RIGHT: {
                stringBuilder.append('1');
                break;
            }
            case TOP_LEFT: {
                stringBuilder.append('2');
                break;
            }
            case TOP_RIGHT: {
                stringBuilder.append('3');
            }
        }
        stringBuilder.append(",");
        stringBuilder.append('0');
        this.stringValue = stringBuilder.toString();
    }

    private void parseStringValue(String string) {
        String[] stringArray = string.split(",");
        this.typeNumber = Integer.parseInt(stringArray[0]);
        if (stringArray.length == 1) {
            return;
        }
        this.fullSpec = true;
        this.whiteStart = stringArray[1].equals("W");
        this.boardWidth = Integer.parseInt(stringArray[2]);
        this.boardHeight = Integer.parseInt(stringArray[3]);
        switch (stringArray[4].charAt(0)) {
            case 'N': {
                this.notation = Notation.NUMERIC;
                break;
            }
            case 'A': {
                this.notation = Notation.ALPHANUMERIC;
                break;
            }
            case 'S': {
                this.notation = Notation.SAN;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        switch (stringArray[4].charAt(1)) {
            case '0': {
                this.startSide = NotationStartSide.BOTTOM_LEFT;
                break;
            }
            case '1': {
                this.startSide = NotationStartSide.BOTTOM_RIGHT;
                break;
            }
            case '2': {
                this.startSide = NotationStartSide.TOP_LEFT;
                break;
            }
            case '3': {
                this.startSide = NotationStartSide.TOP_RIGHT;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public final String getStringValue() {
        return this.stringValue;
    }

    public final void setShowFullSpec(boolean bl) {
        this.showFullSpec = bl;
        this.updateStringValue();
    }

    public final int getTypeNumber() {
        return this.typeNumber;
    }

    public final boolean isWhiteStart() {
        return this.whiteStart;
    }

    public final int getBoardWidth() {
        return this.boardWidth;
    }

    public final int getBoardHeight() {
        return this.boardHeight;
    }

    public final NotationStartSide getStartSide() {
        return this.startSide;
    }

    public final Notation getNotation() {
        return this.notation;
    }

    public final boolean isInvertFlag() {
        return false;
    }

    public final boolean isFullSpec() {
        return this.fullSpec;
    }

    public final boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof PDNGameType)) {
            return false;
        }
        return this.getTypeNumber() == ((PDNGameType)object).getTypeNumber();
    }

    public final int hashCode() {
        return new Integer(this.getTypeNumber()).hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Notation {
        NUMERIC,
        ALPHANUMERIC,
        SAN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NotationStartSide {
        BOTTOM_LEFT,
        BOTTOM_RIGHT,
        TOP_LEFT,
        TOP_RIGHT;

    }
}

